/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.tooltrims;

import archives.tater.tooltrims.ToolTrimsDPCompat;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2240;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5630;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class ToolTrimsCommands {
    private static final SimpleCommandExceptionType ERROR_NOPLAYER = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.tooltrims.error.noplayer"));
    private static final SimpleCommandExceptionType ERROR_MISSING_DATAPACK = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.tooltrims.error.demigrate.missing_datapack"));
    private static final DynamicCommandExceptionType MIGRATE_FAIL = new DynamicCommandExceptionType(itemText -> class_2561.method_43469((String)"commands.tooltrims.migrate.error.fail", (Object[])new Object[]{itemText}));
    private static final DynamicCommandExceptionType DEMIGRATE_FAIL = new DynamicCommandExceptionType(itemText -> class_2561.method_43469((String)"commands.tooltrims.demigrate.error.fail", (Object[])new Object[]{itemText}));

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tooltrims").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"migrate").executes(ctx -> {
            ToolTrimsCommands.migrate(registryAccess, (CommandContext<class_2168>)ctx, ((class_2168)ctx.getSource()).method_44023(), class_1304.field_6173.method_32320(98), false);
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"slot", (ArgumentType)class_2240.method_9473()).executes(ctx -> {
            ToolTrimsCommands.migrate(registryAccess, (CommandContext<class_2168>)ctx, ((class_2168)ctx.getSource()).method_44023(), class_2240.method_9469((CommandContext)ctx, (String)"slot"), false);
            return 1;
        })).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            ToolTrimsCommands.migrate(registryAccess, (CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target"), class_2240.method_9469((CommandContext)ctx, (String)"slot"), false);
            return 1;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"demigrate").executes(ctx -> {
            ToolTrimsCommands.migrate(registryAccess, (CommandContext<class_2168>)ctx, ((class_2168)ctx.getSource()).method_44023(), class_1304.field_6173.method_32320(98), true);
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"slot", (ArgumentType)class_2240.method_9473()).executes(ctx -> {
            ToolTrimsCommands.migrate(registryAccess, (CommandContext<class_2168>)ctx, ((class_2168)ctx.getSource()).method_44023(), class_2240.method_9469((CommandContext)ctx, (String)"slot"), true);
            return 1;
        })).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            ToolTrimsCommands.migrate(registryAccess, (CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"target"), class_2240.method_9469((CommandContext)ctx, (String)"slot"), true);
            return 1;
        }))))));
    }

    public static void migrate(class_7157 registries, CommandContext<class_2168> ctx, @Nullable class_3222 player, int slot, boolean reverse) throws CommandSyntaxException {
        class_1799 newStack;
        if (!ToolTrimsDPCompat.isDatapackRunning(((class_2168)ctx.getSource()).method_9211())) {
            throw ERROR_MISSING_DATAPACK.create();
        }
        if (player == null) {
            throw ERROR_NOPLAYER.create();
        }
        class_5630 stackReference = player.method_32318(slot);
        class_1799 currentStack = stackReference.method_32327();
        class_1799 class_17992 = newStack = reverse ? ToolTrimsDPCompat.demigrateItem(player.method_51469(), (class_7225.class_7874)registries, currentStack) : ToolTrimsDPCompat.migrateItem((class_1937)player.method_51469(), currentStack);
        if (newStack == null) {
            throw (reverse ? DEMIGRATE_FAIL : MIGRATE_FAIL).create((Object)currentStack.method_7954());
        }
        stackReference.method_32332(newStack);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)(reverse ? "commands.tooltrims.demigrate.success" : "commands.tooltrims.migrate.success"), (Object[])new Object[]{newStack.method_7954()}), true);
    }
}

