package archives.tater.tooltrims.datagen;

import archives.tater.tooltrims.ToolTrims;
import archives.tater.tooltrims.ToolTrimsPatterns;
import archives.tater.tooltrims.item.ToolTrimsItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider;
import net.minecraft.class_161;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_189;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8055;
import net.minecraft.class_8508;
import net.minecraft.class_8779;
import net.minecraft.class_8782.class_8797;
import net.minecraft.class_9334;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class AdvancementGenerator extends FabricAdvancementProvider {
    public AdvancementGenerator(FabricDataOutput output, CompletableFuture<class_7874> wrapperLookup) {
        super(output, wrapperLookup);
    }

    private static class_161.class_162 requireAllToolTrims(class_161.class_162 builder) {
        for (var pattern : ToolTrimsPatterns.PATTERNS) {
            var id = pattern.method_29177();
            builder.method_705("tool_trimmed_" + id, class_8508.class_8509.method_51352(class_5321.method_29179(class_7924.field_52178, id.method_48331("_tool_trim_smithing_template_smithing_trim"))));
        }
        return builder;
    }

    private static class_161.class_162 createWithAllToolTrims() {
        return requireAllToolTrims(class_161.class_162.method_51698());
    }

    @Override
    public void generateAdvancement(class_7874 wrapperLookup, Consumer<class_8779> consumer) {
        var shinyToolsIcon = new class_1799(class_1802.field_22022);
        shinyToolsIcon.method_57379(class_9334.field_49607, new class_8053(
                wrapperLookup.method_46762(class_7924.field_42083).method_46747(class_8055.field_42011),
                wrapperLookup.method_46762(class_7924.field_42082).method_46747(ToolTrimsPatterns.FROST)
        ));

        var shinyTools = createWithAllToolTrims()
                .method_701(new class_8779(class_2960.method_60656("adventure/root"), null)) // fake advancement
                .method_20416(shinyToolsIcon,
                        class_2561.method_43471("advancements.adventure.shiny_tools.title"),
                        class_2561.method_43471("advancements.adventure.shiny_tools.description"),
                        null,
                        class_189.field_1254,
                        true,
                        true,
                        false)
                .method_704(class_8797.field_1257)
                .method_694(consumer, ToolTrims.id("adventure/shiny_tools").toString());

        createWithAllToolTrims()
                .method_701(shinyTools)
                .method_697(
                        ToolTrimsItems.LINEAR_TOOL_TRIM_SMITHING_TEMPLATE,
                        class_2561.method_43471("advancements.adventure.tools_of_all_styles.title"),
                        class_2561.method_43471("advancements.adventure.tools_of_all_styles.description"),
                        null,
                        class_189.field_1250,
                        true,
                        true,
                        false)
                .method_704(class_8797.field_16882)
                .method_694(consumer, ToolTrims.id("adventure/tools_of_all_styles").toString());
    }
}
