package archives.tater.tooltrims.datagen;

import archives.tater.tooltrims.ToolTrims;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_4915;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import java.util.Optional;

public class EnchancementModelGenerator extends ModelGenerator {
    public EnchancementModelGenerator(FabricDataOutput output) {
        super(output);
    }

    public static class_2960 enchancementId(String path) {
        return class_2960.method_60655("enchancement", path);
    }

    private record CrossbowModel(
            String path,
            String predicate,
            float predicateValue,
            class_1792 fakeItem
    ) {
        public CrossbowModel(String path, String predicate, float predicateValue) {
            this(path, predicate, predicateValue,
                    class_1802.method_51348(class_5321.method_29179(class_7924.field_41197, enchancementId(path)), class_1792::new, new class_1792.class_1793()));
        }

        public CrossbowModel(String path, String predicate) {
            this(path, predicate, 1);
        }
    }

    private static final CrossbowModel[] crossbowModels = {
            new CrossbowModel("crossbow_amethyst", "amethyst_shard"),
            new CrossbowModel("crossbow_torch", "torch"),
            new CrossbowModel("crossbow_brimstone_0", "brimstone", 1 / 6f),
            new CrossbowModel("crossbow_brimstone_1", "brimstone", 2 / 6f),
            new CrossbowModel("crossbow_brimstone_2", "brimstone", 3 / 6f),
            new CrossbowModel("crossbow_brimstone_3", "brimstone", 4 / 6f),
            new CrossbowModel("crossbow_brimstone_4", "brimstone", 5 / 6f),
            new CrossbowModel("crossbow_brimstone_5", "brimstone", 1f)
    };

    // Needed to register fake items
    public static void register() {}

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {
        var twoLayersTemplate = new class_4942(Optional.of(ToolTrims.id("item/template_crossbow")), Optional.empty(), class_4945.field_42089);

        var crossbowPullId = class_2960.method_60656("crossbow_pulling_2");

        for (var model : crossbowModels) {
            var templateModelId = ToolTrims.id(model.path).method_45138("item/enchancement/");
            twoLayersTemplate.method_25852(templateModelId, new class_4944().method_25868(class_4945.field_42089, templateModelId), itemModelGenerator.field_55246);
            var templateModel = new class_4942(Optional.of(templateModelId), Optional.empty(), class_4945.field_23006);
            itemModelGenerator.field_55245.method_65460(model.fakeItem, generateTrimmedToolModels(enchancementId(model.path), crossbowPullId, templateModel, itemModelGenerator));
        }

//        var crossbowOverrides = generateCrossbowOverrides(itemModelGenerator, false);
//        for (var model : crossbowModels) {
//            var templateModelId = ToolTrims.id(model.path).withPrefixedPath("item/enchancement/");
//            twoLayersTemplate.upload(templateModelId, new TextureMap().put(TextureKey.LAYER1, templateModelId), itemModelGenerator.modelCollector);
//            var templateModel = new Model(Optional.of(templateModelId), Optional.empty(), TextureKey.LAYER0);
//            registerTrimmedTool(crossbowOverrides, enchancementId(model.path), crossbowPullId, templateModel, Map.of("charged", 1, enchancementId(model.predicate).toString(), model.predicateValue), true, true, itemModelGenerator.modelCollector);
//        }
//
//        uploadCrossbow(itemModelGenerator, crossbowOverrides);
    }
}
