package archives.tater.tooltrims.datagen;

import archives.tater.tooltrims.ToolTrimsTags;
import archives.tater.tooltrims.item.ToolTrimsItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2446;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_7800;
import net.minecraft.class_7924;
import net.minecraft.class_8056;
import net.minecraft.class_8076;
import net.minecraft.class_8790;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class TTRecipeGenerator extends class_2446 {

    protected TTRecipeGenerator(class_7874 registries, class_8790 exporter) {
        super(registries, exporter);
    }

    public void offerToolTrimRecipe(class_1792 template, class_6880<class_8056> pattern, class_5321<class_1860<?>> registryKey) {
        class_8076.method_48540(
                        class_1856.method_8091(template), method_62748(ToolTrimsTags.TRIMMABLE_TOOLS), method_62748(ToolTrimsTags.TOOL_TRIM_MATERIALS), pattern, class_7800.field_40642
                )
                .method_48541("has_smithing_trim_template", method_10426(template))
                .method_48542(field_53721, registryKey);
    }

    @Override
    public void method_10419() {
        Map<class_1792, class_1792> materials = Map.of(
                ToolTrimsItems.LINEAR_TOOL_TRIM_SMITHING_TEMPLATE, class_1802.field_8260,
                ToolTrimsItems.TRACKS_TOOL_TRIM_SMITHING_TEMPLATE, class_1802.field_20412,
                ToolTrimsItems.CHARGE_TOOL_TRIM_SMITHING_TEMPLATE, class_1802.field_29025,
                ToolTrimsItems.FROST_TOOL_TRIM_SMITHING_TEMPLATE, class_1802.field_8246
        );
        ToolTrimsItems.SMITHING_TEMPLATES.forEach((entry, templateItem) -> {
            offerToolTrimRecipe(templateItem, field_48981.method_46762(class_7924.field_42082).method_46747(entry), class_5321.method_29179(class_7924.field_52178, entry.method_29177().method_48331("_tool_trim_smithing_template_smithing_trim")));
            method_48533(templateItem, materials.get(templateItem));
        });
    }

    public static class Provider extends FabricRecipeProvider {

        public Provider(FabricDataOutput output, CompletableFuture<class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        @Override
        protected class_2446 method_62766(class_7874 wrapperLookup, class_8790 exporter) {
            return new TTRecipeGenerator(wrapperLookup, exporter);
        }

        @Override
        public String method_10321() {
            return "Tool Trims Recipes";
        }
    }
}
