package archives.tater.tooltrims.item;

import archives.tater.tooltrims.ToolTrims;
import archives.tater.tooltrims.ToolTrimsPatterns;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import net.minecraft.class_8056;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.Function;

public class ToolTrimsItems {

    private static class_1792 register(String path, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        return class_1802.method_51348(class_5321.method_29179(class_7924.field_41197, ToolTrims.id(path)), factory, settings);
    }

    private static class_1792 registerToolTemplate(String name, class_1814 rarity) {
        return register(name + "_tool_trim_smithing_template", ToolTrimSmithingTemplate::of, new class_1792.class_1793().method_7894(rarity));
    }

    public static final class_1792 LINEAR_TOOL_TRIM_SMITHING_TEMPLATE = registerToolTemplate("linear", class_1814.field_8907);
    public static final class_1792 TRACKS_TOOL_TRIM_SMITHING_TEMPLATE = registerToolTemplate("tracks", class_1814.field_8907);
    public static final class_1792 CHARGE_TOOL_TRIM_SMITHING_TEMPLATE = registerToolTemplate("charge", class_1814.field_8904);
    public static final class_1792 FROST_TOOL_TRIM_SMITHING_TEMPLATE = registerToolTemplate("frost", class_1814.field_8907);

    public static final Map<class_5321<class_8056>, class_1792> SMITHING_TEMPLATES = Map.of(
            ToolTrimsPatterns.LINEAR, LINEAR_TOOL_TRIM_SMITHING_TEMPLATE,
            ToolTrimsPatterns.TRACKS, TRACKS_TOOL_TRIM_SMITHING_TEMPLATE,
            ToolTrimsPatterns.CHARGE, CHARGE_TOOL_TRIM_SMITHING_TEMPLATE,
            ToolTrimsPatterns.FROST, FROST_TOOL_TRIM_SMITHING_TEMPLATE
    );

    public static void register() {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062).register(entries ->
            entries.addAfter(class_1802.field_49818,
                    LINEAR_TOOL_TRIM_SMITHING_TEMPLATE,
                    TRACKS_TOOL_TRIM_SMITHING_TEMPLATE,
                    CHARGE_TOOL_TRIM_SMITHING_TEMPLATE,
                    FROST_TOOL_TRIM_SMITHING_TEMPLATE)
        );

        if (System.getProperty("fabric-api.datagen") != null) {
            try {
                var enchancementClass = Class.forName("archives.tater.tooltrims.datagen.EnchancementModelGenerator");
                enchancementClass.getMethod("register").invoke(null);
            } catch (NoSuchMethodException | ClassNotFoundException | IllegalAccessException |
                     InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}
