package archives.tater.tooltrims.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static archives.tater.tooltrims.ToolTrimsDPCompat.shouldDeleteItem;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

@Mixin(class_1542.class)
public abstract class ItemEntityMixin extends class_1297 {
    @Shadow public abstract void setStack(class_1799 stack);

    public ItemEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(
            method = "<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;DDD)V",
            at = @At("TAIL")
    )
    private void checkDeletion(class_1937 world, double x, double y, double z, class_1799 stack, double velocityX, double velocityY, double velocityZ, CallbackInfo ci) {
        if (!world.method_8608() && shouldDeleteItem(stack, world)) setStack(class_1799.field_8037);
    }
}
