package archives.tater.tooltrims;

import archives.tater.tooltrims.item.ToolTrimsItems;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1531;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_7871.class_7872;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8055;
import net.minecraft.class_8056;
import net.minecraft.class_8567;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ToolTrimsDPCompat {
    public static final List<class_5321<class_8054>> legacyMaterialOrder = List.of(
            class_8055.field_42013,
            class_8055.field_42008,
            class_8055.field_42011,
            class_8055.field_42010,
            class_8055.field_42009,
            class_8055.field_42005,
            class_8055.field_42012,
            class_8055.field_42006,
            class_8055.field_42004,
            class_8055.field_42007
    );

    public static final List<class_5321<class_8056>> legacyPatternOrder = List.of(
            ToolTrimsPatterns.LINEAR,
            ToolTrimsPatterns.TRACKS,
            ToolTrimsPatterns.CHARGE,
            ToolTrimsPatterns.FROST
    );

    private static class_5321<class_52> templateLootTable(String trim) {
        return class_5321.method_29179(class_7924.field_50079, class_2960.method_60655("tooltrims", "items/" + trim + "_smithing_template"));
    }

    private static final Map<class_1792, class_5321<class_52>> TEMPLATE_LOOT_TABLES = Map.of(
            ToolTrimsItems.LINEAR_TOOL_TRIM_SMITHING_TEMPLATE, templateLootTable("linear"),
            ToolTrimsItems.TRACKS_TOOL_TRIM_SMITHING_TEMPLATE, templateLootTable("tracks"),
            ToolTrimsItems.CHARGE_TOOL_TRIM_SMITHING_TEMPLATE, templateLootTable("charge"),
            ToolTrimsItems.FROST_TOOL_TRIM_SMITHING_TEMPLATE, templateLootTable("frost")
    );

    private static final String disableGamerule = "/gamerule " + ToolTrimsGamerules.DELETE_TOOLSMITHING_TABLES.method_20771() + " false";

    private static boolean gameruleWasEnabled = false;

    public static void register() {
        //noinspection OptionalGetWithoutIsPresent
        ResourceManagerHelper.registerBuiltinResourcePack(
                ToolTrims.id("legacy"),
                FabricLoader.getInstance().getModContainer(ToolTrims.MOD_ID).get(),
                class_2561.method_43470("Tool Trims Legacy"),
                ResourcePackActivationType.NORMAL
        );

        gameruleWasEnabled = false;

        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            var state = State.ofServer(server);
            if (!state.hasCheckedForDP()) {
                if (wasDatapackUsed(server)) {
                    server.method_3767().method_20746(ToolTrimsGamerules.DELETE_TOOLSMITHING_TABLES).method_20758(true, server);
                    gameruleWasEnabled = true;
                    ToolTrims.LOGGER.warn(class_2561.method_43469("tooltrims.warning.auto_enable", disableGamerule).getString());
                }
                state.setCheckedForDP();
            }
            if (isDatapackRunning(server)) {
                ToolTrims.LOGGER.warn(class_2561.method_43471("tooltrims.warning.datapack_running").getString());
            }
        });

        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (!server.method_3860()) {
                if (gameruleWasEnabled) {
                    handler.field_14140.method_43496(class_2561.method_43469("tooltrims.warning.auto_enable", disableGamerule));
                }
                if (isDatapackRunning(server)) {
                    handler.field_14140.method_43496(class_2561.method_43471("tooltrims.warning.datapack_running").method_27692(class_124.field_1065));
                }
            }
        });
    }

    public static boolean wasDatapackUsed(MinecraftServer server) {
        return server.method_3845().method_1163().contains("310_recipe");
    }

    public static boolean isDatapackRunning(MinecraftServer server) {
        return server.method_3740()
                .method_29462(class_2960.method_60656("load"))
                .stream().anyMatch(function -> function.comp_1994().equals(class_2960.method_60655("tooltrims", "load")));
    }

    public static boolean shouldDeleteToolsmithingTable(class_1531 armorStand) {
        return armorStand.method_37908().method_8450().method_8355(ToolTrimsGamerules.DELETE_TOOLSMITHING_TABLES) &&
                (armorStand.method_5752().contains("310_toolsmithing_table") || armorStand.method_5752().contains("310_place_toolsmithing_table")) &&
                        armorStand.method_37908().method_18460(armorStand, 6) != null;
    }

    public static void deleteToolsmithingTable(class_1531 armorStand) {
        if (armorStand.method_5752().contains("310_toolsmithing_table") && armorStand.method_37908().method_8320(armorStand.method_24515()).method_27852(class_2246.field_16328)) {
            armorStand.method_37908().method_22352(armorStand.method_24515(), false);
        }
        armorStand.method_5775(new class_1799(class_1802.field_8118, 4));
        armorStand.method_5775(new class_1799(class_1802.field_27022, 2));
        armorStand.method_31472();
    }

    public static int getCustomModelData(class_1799 itemStack, int defaultValue) {
        var customModelData = itemStack.method_57824(class_9334.field_49637);
        return customModelData == null ? defaultValue : customModelData.comp_2382();
    }

    public static int getCustomModelData(class_5321<class_8054> material, class_5321<class_8056> pattern) {
        return 311001 + ToolTrimsDPCompat.legacyPatternOrder.indexOf(pattern) * ToolTrimsDPCompat.legacyMaterialOrder.size() + ToolTrimsDPCompat.legacyMaterialOrder.indexOf(material);
    }

    public static class_8053 getTrim(class_7872 registryLookup, int customModelData) {
        var value = customModelData - 311001;
        var pattern = legacyPatternOrder.get(value / legacyMaterialOrder.size());
        var material = legacyMaterialOrder.get(value % legacyMaterialOrder.size());
        return new class_8053(
                registryLookup.method_46751(class_7924.field_42083).method_46747(material),
                registryLookup.method_46751(class_7924.field_42082).method_46747(pattern)
        );
    }

    public static class_8053 getTrim(class_1937 world, int customModelData) {
        return getTrim(world.method_30349().method_46758(), customModelData);
    }

    public static boolean shouldDeleteItem(class_1799 itemStack, @Nullable class_1937 world) {
        if (world != null && !world.method_8450().method_8355(ToolTrimsGamerules.DELETE_TOOLSMITHING_TABLES)) return false;
        if (!itemStack.method_31574(class_1802.field_8238)) return false;
        var customModelData = getCustomModelData(itemStack, 0);
        return 312001 <= customModelData && customModelData <= 312021;
    }

    public static @Nullable class_1799 migrateItem(class_1937 world, class_1799 itemStack) {
        if (itemStack.method_31574(class_1802.field_8238)) {
            var customModelData = getCustomModelData(itemStack, 0);
            if (312001 <= customModelData && customModelData <= 312021) return class_1799.field_8037;
            var item = switch (customModelData) {
                case 313001 -> ToolTrimsItems.LINEAR_TOOL_TRIM_SMITHING_TEMPLATE;
                case 313002 -> ToolTrimsItems.TRACKS_TOOL_TRIM_SMITHING_TEMPLATE;
                case 313003 -> ToolTrimsItems.CHARGE_TOOL_TRIM_SMITHING_TEMPLATE;
                case 313004 -> ToolTrimsItems.FROST_TOOL_TRIM_SMITHING_TEMPLATE;
                default -> null;
            };
            if (item == null) return null;
            return new class_1799(item, itemStack.method_7947());
        }
        if (itemStack.method_31573(ToolTrimsTags.TRIMMABLE_TOOLS)) {
            var customModelData = getCustomModelData(itemStack, 0);
            if (customModelData == 0) return null;
            itemStack.method_57379(class_9334.field_49632, class_9290.field_49340);
            itemStack.method_57381(class_9334.field_49637);
            var customDataComponent = itemStack.method_57824(class_9334.field_49628);
            if (customDataComponent != null) {
                var customData = customDataComponent.method_57461();
                customData.method_10551("combination");
                customData.method_10551("trimmed_tool");
                if (customData.method_33133())
                    itemStack.method_57381(class_9334.field_49628);
                else
                    itemStack.method_57379(class_9334.field_49628, class_9279.method_57456(customData));
            }
            if (itemStack.method_57824(class_9334.field_49607) == null) {
                itemStack.method_57379(class_9334.field_49607, getTrim(world, customModelData));
            }
            return itemStack;
        }
        return null;
    }

    public static @Nullable class_1799 demigrateItem(class_3218 world, class_7874 registries, class_1799 stack) {
        if (stack.method_31573(ToolTrimsTags.TRIMMABLE_TOOLS)) {
            var trim = stack.method_57824(class_9334.field_49607);
            if (trim == null) return null;
            var id = class_2960.method_60655("tooltrims", "trims/" + trim.method_48424().method_40230().orElseThrow().method_29177().method_12832() + "_" + trim.method_48431().method_40230().orElseThrow().method_29177().method_12832());
            var modifier = registries.method_46762(class_7924.field_50080).method_46746(class_5321.method_29179(class_7924.field_50080, id));
            if (modifier.isEmpty()) return null;
            modifier.get().comp_349().apply(stack, new class_47.class_48(new class_8567.class_8568(world).method_51875(class_173.field_1175)).method_309(Optional.empty()));
            stack.method_57381(class_9334.field_49607);
            return stack;
        }
        var templateLootTable = TEMPLATE_LOOT_TABLES.get(stack.method_7909());
        if (templateLootTable != null) {
            var stacks = world.method_8503().method_58576().method_58295(templateLootTable)
                    .method_51878(new class_8567.class_8568(world).method_51875(class_173.field_1175));
            if (stacks.isEmpty()) return null;
            var newStack = stacks.getFirst();
            newStack.method_7939(stack.method_7947());
            newStack.method_59692(stack.method_57380());
            return newStack;
        }
        return null;
    }

    public static class State extends class_18 {
        private static final String CHECKED_NBT = "CheckedForDP";

        private boolean checkedForDP;

        @Override
        public class_2487 method_75(class_2487 nbt, class_7874 wrapperLookup) {
            nbt.method_10556(CHECKED_NBT, checkedForDP);
            return nbt;
        }

        public boolean hasCheckedForDP() {
            return checkedForDP;
        }

        public void setCheckedForDP() {
            this.checkedForDP = true;
            method_78(true);
        }

        public static State fromNbt(class_2487 nbt, class_7874 wrapperLookup) {
            var state = new State();
            state.checkedForDP = nbt.method_10577(CHECKED_NBT);
            return state;
        }

        private static final class_8645<State> TYPE = new class_8645<>(State::new, State::fromNbt, null);

        public static State ofServer(MinecraftServer server) {
            return Objects.requireNonNull(server.method_3847(class_1937.field_25179))
                    .method_17983()
                    .method_17924(TYPE, ToolTrims.MOD_ID);
        }
    }
}
