package archives.tater.tooltrims;

import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1685;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9334;

@SuppressWarnings("UnstableApiUsage")
public class TridentTextures {
    private static final Map<class_5321<class_8056>, Map<class_5321<class_8054>, class_2960>> TEXTURE_IDS = new HashMap<>();

    public static class_2960 getTextureId(class_5321<class_8056> pattern, class_5321<class_8054> material) {
        return TEXTURE_IDS
                .computeIfAbsent(pattern, x -> new HashMap<>())
                .computeIfAbsent(material, x -> ToolTrims.id("textures/entity/trident/trident_"
                    + pattern.method_29177().method_12832()
                    + "_"
                    + material.method_29177().method_12832()
                    + ".png"));
    }

    public static class_2960 getTextureId(class_6880<class_8056> pattern, class_6880<class_8054> material) {
        return getTextureId(pattern.method_40230().orElseThrow(), material.method_40230().orElseThrow());
    }

    public static @Nullable class_2960 getTextureId(class_8053 trim) {
        if (trim == null) return null;
        return getTextureId(trim.method_48424(), trim.method_48431());
    }

    public static @Nullable class_2960 getTextureId(class_1799 stack) {
        return getTextureId(stack.method_57824(class_9334.field_49607));
    }

    public static @Nullable class_2960 getTextureId(class_1685 tridentEntity) {
        return getTextureId(tridentEntity.getAttached(ToolTrimsDataAttachment.TRIDENT_TRIM));
    }
}
