package archives.tater.tooltrims.datagen;

import archives.tater.tooltrims.ToolTrims;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2960;
import net.minecraft.class_4915;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import java.util.Map;
import java.util.Optional;

public class EnchancementModelGenerator extends ModelGenerator {
    public EnchancementModelGenerator(FabricDataOutput output) {
        super(output);
    }

    public static class_2960 enchancementId(String path) {
        return class_2960.method_60655("enchancement", path);
    }

    private record CrossbowModel(
            String path,
            String predicate,
            float predicateValue
    ) {
        public CrossbowModel(String path, String predicate) {
            this(path, predicate, 1);
        }
    }

    private static final CrossbowModel[] crossbowModels = {
            new CrossbowModel("crossbow_amethyst", "amethyst_shard"),
            new CrossbowModel("crossbow_torch", "torch"),
            new CrossbowModel("crossbow_brimstone_0", "brimstone", 1 / 6f),
            new CrossbowModel("crossbow_brimstone_1", "brimstone", 2 / 6f),
            new CrossbowModel("crossbow_brimstone_2", "brimstone", 3 / 6f),
            new CrossbowModel("crossbow_brimstone_3", "brimstone", 4 / 6f),
            new CrossbowModel("crossbow_brimstone_4", "brimstone", 5 / 6f),
            new CrossbowModel("crossbow_brimstone_5", "brimstone", 1f)
    };

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {
        var twoLayersTemplate = new class_4942(Optional.of(ToolTrims.id("item/template_crossbow")), Optional.empty(), class_4945.field_42089);

        var crossbowPullId = class_2960.method_60656("crossbow_pulling_2");
        var crossbowOverrides = generateCrossbowOverrides(itemModelGenerator, false);
        for (var model : crossbowModels) {
            var templateModelId = ToolTrims.id(model.path).method_45138("item/enchancement/");
            twoLayersTemplate.method_25852(templateModelId, new class_4944().method_25868(class_4945.field_42089, templateModelId), itemModelGenerator.field_22844);
            var templateModel = new class_4942(Optional.of(templateModelId), Optional.empty(), class_4945.field_23006);
            generateTrimmedOverrides(crossbowOverrides, enchancementId(model.path), crossbowPullId, templateModel, Map.of("charged", 1, enchancementId(model.predicate).toString(), model.predicateValue), true, true, itemModelGenerator.field_22844);
        }

        uploadCrossbow(itemModelGenerator, crossbowOverrides);
    }
}
