package archives.tater.tooltrims.datagen;

import archives.tater.tooltrims.ToolTrims;
import archives.tater.tooltrims.ToolTrimsDPCompat;
import archives.tater.tooltrims.ToolTrimsPatterns;
import archives.tater.tooltrims.item.ToolTrimsItems;
import archives.tater.tooltrims.mixin.ItemModelGeneratorAccessor;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7923;
import net.minecraft.data.client.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

import static archives.tater.tooltrims.ToolTrimsPatterns.TRIM_PATTERN_PREDICATE;

public class ModelGenerator extends FabricModelProvider {
    public ModelGenerator(FabricDataOutput output) {
        super(output);
    }

    private static final List<class_4915.class_8072> materials = ItemModelGeneratorAccessor.TRIM_MATERIALS();

    private static final List<class_1792> standardTools = List.of(
            class_1802.field_8091,
            class_1802.field_8876,
            class_1802.field_8647,
            class_1802.field_8406,
            class_1802.field_8167,
            class_1802.field_8528,
            class_1802.field_8776,
            class_1802.field_8387,
            class_1802.field_8062,
            class_1802.field_8431,
            class_1802.field_8845,
            class_1802.field_8322,
            class_1802.field_8335,
            class_1802.field_8825,
            class_1802.field_8303,
            class_1802.field_8371,
            class_1802.field_8699,
            class_1802.field_8403,
            class_1802.field_8475,
            class_1802.field_8609,
            class_1802.field_8802,
            class_1802.field_8250,
            class_1802.field_8377,
            class_1802.field_8556,
            class_1802.field_8527,
            class_1802.field_22022,
            class_1802.field_22023,
            class_1802.field_22024,
            class_1802.field_22025,
            class_1802.field_22026,
            class_1802.field_8547
    );

    protected static final class_4942 TEMPLATE_BOW = new class_4942(Optional.of(ToolTrims.id("item/template_bow")), Optional.empty(), class_4945.field_23006);
    protected static final class_4942 TEMPLATE_CROSSBOW = new class_4942(Optional.of(ToolTrims.id("item/template_crossbow")), Optional.empty(), class_4945.field_23006);

    protected static class_2960 getSuffixedModelId(class_2960 itemId, String pattern, String material) {
        return ToolTrims.id("item/trims/" + itemId.method_12836() + "/" + itemId.method_12832() + "_" + pattern+ "_" + material);
    }

    protected static JsonArray generateTrimmedOverrides(JsonArray overrides, class_2960 modelId, class_2960 textureId, class_4942 model, Map<String, Number> extraPredicates, boolean includeBase, boolean upload, BiConsumer<class_2960, Supplier<JsonElement>> writer) {
        if (includeBase) {
            var override = new JsonObject();
            var predicate = new JsonObject();
            extraPredicates.forEach(predicate::addProperty);
            override.add("predicate", predicate);
            override.addProperty("model", modelId.method_45138("item/").toString());
            overrides.add(override);
        }

        for (var pattern : ToolTrimsDPCompat.legacyPatternOrder) {
            for (var material : ToolTrimsDPCompat.legacyMaterialOrder) {
                var trimmedModelId = getSuffixedModelId(modelId, pattern.method_29177().method_12832(), material.method_29177().method_12832());

                var override = new JsonObject();
                var predicate = new JsonObject();
                extraPredicates.forEach(predicate::addProperty);
                predicate.addProperty("custom_model_data", ToolTrimsDPCompat.getCustomModelData(material, pattern));
                override.add("predicate", predicate);
                override.addProperty("model", trimmedModelId.toString());
                overrides.add(override);
            }
        }

        for (var pattern : ToolTrimsPatterns.PATTERNS) {
            for (var material : materials) {
                var trimmedModelId = getSuffixedModelId(modelId, pattern.method_29177().method_12832(), material.comp_1219());
                var trimmedTextureId = getSuffixedModelId(textureId, pattern.method_29177().method_12832(), material.comp_1219());

                if (upload) model.method_25852(trimmedModelId, class_4944.method_25895(trimmedTextureId), writer);

                var override = new JsonObject();
                var predicate = new JsonObject();
                extraPredicates.forEach(predicate::addProperty);
                predicate.addProperty("trim_type", material.comp_1220());
                predicate.addProperty(TRIM_PATTERN_PREDICATE.toString(), ToolTrimsPatterns.getModelIndex(pattern));
                override.add("predicate", predicate);
                override.addProperty("model", trimmedModelId.toString());
                overrides.add(override);
            }
        }

        return overrides;
    }

    protected static JsonArray generateTrimmedOverrides(JsonArray overrides, class_2960 toolId, class_4942 model, Map<String, Number> extraPredicates, boolean includeBase, boolean upload, BiConsumer<class_2960, Supplier<JsonElement>> writer) {
        return generateTrimmedOverrides(overrides, toolId, toolId, model, extraPredicates, includeBase, upload, writer);
    }

    protected static JsonArray generateTrimmedOverrides(JsonArray overrides, class_2960 toolId, class_4942 model, Map<String, Number> extraPredicates, boolean includeBase, BiConsumer<class_2960, Supplier<JsonElement>> writer) {
        return generateTrimmedOverrides(overrides, toolId, toolId, model, extraPredicates, includeBase, true, writer);
    }

    protected static JsonArray generateTrimmedOverrides(class_2960 toolId, class_4942 model, BiConsumer<class_2960, Supplier<JsonElement>> writer) {
        return generateTrimmedOverrides(new JsonArray(), toolId, model, Map.of(), false, true, writer);
    }

    protected static JsonArray generateTrimmedOverrides(class_2960 modelId, class_2960 textureId, class_4942 model, BiConsumer<class_2960, Supplier<JsonElement>> writer) {
        return generateTrimmedOverrides(new JsonArray(), modelId, textureId, model, Map.of(), false, true, writer);
    }

    protected static void upload(class_4942 model, class_2960 identifier, class_4944 textureMap, BiConsumer<class_2960, Supplier<JsonElement>> writer, Consumer<JsonObject> postProcessJson) {
        model.method_48525(identifier, textureMap, writer, (id, textures) -> {
            var json = model.method_48524(id, textures);
            postProcessJson.accept(json);
            return json;
        });
    }

    protected static void upload(class_4942 model, class_1792 item, class_4944 textureMap, BiConsumer<class_2960, Supplier<JsonElement>> writer, Consumer<JsonObject> postProcessJson) {
        upload(model, class_4941.method_25840(item), textureMap, writer, postProcessJson);
    }

    protected static void upload(class_4942 model, class_2960 identifier, class_4944 textureMap, BiConsumer<class_2960, Supplier<JsonElement>> writer, JsonArray overrides) {
        upload(model, identifier, textureMap, writer, json -> json.add("overrides", overrides));
    }

    protected static void upload(class_4942 model, class_1792 item, class_4944 textureMap, BiConsumer<class_2960, Supplier<JsonElement>> writer, JsonArray overrides) {
        upload(model, item, textureMap, writer, json -> json.add("overrides", overrides));
    }

    protected static JsonArray generateCrossbowOverrides(class_4915 itemModelGenerator, boolean upload) {
        var crossbowOverrides = new JsonArray();
        var crossbowId = class_7923.field_41178.method_10221(class_1802.field_8399);
        generateTrimmedOverrides(crossbowOverrides, crossbowId, TEMPLATE_CROSSBOW, Map.of(), false, upload, itemModelGenerator.field_22844);
        generateTrimmedOverrides(crossbowOverrides, crossbowId.method_48331("_pulling_0"), TEMPLATE_CROSSBOW, Map.of("pulling", 1), true, upload, itemModelGenerator.field_22844);
        generateTrimmedOverrides(crossbowOverrides, crossbowId.method_48331("_pulling_1"), TEMPLATE_CROSSBOW, Map.of("pulling", 1, "pull", 0.58f), true, upload, itemModelGenerator.field_22844);
        generateTrimmedOverrides(crossbowOverrides, crossbowId.method_48331("_pulling_2"), TEMPLATE_CROSSBOW, Map.of("pulling", 1, "pull", 1), true, upload, itemModelGenerator.field_22844);
        generateTrimmedOverrides(crossbowOverrides, crossbowId.method_48331("_arrow"), TEMPLATE_CROSSBOW, Map.of("charged", 1), true, upload, itemModelGenerator.field_22844);
        generateTrimmedOverrides(crossbowOverrides, crossbowId.method_48331("_firework"), TEMPLATE_CROSSBOW, Map.of("charged", 1, "firework", 1), true, upload, itemModelGenerator.field_22844);
        return crossbowOverrides;
    }

    protected static void uploadCrossbow(class_4915 itemModelGenerator, JsonArray crossbowOverrides) {
        upload(TEMPLATE_CROSSBOW, class_1802.field_8399, class_4944.method_25895(class_4944.method_25876(class_1802.field_8399).method_48331("_standby")), itemModelGenerator.field_22844, crossbowOverrides);
    }

    @Override
    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {

    }

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {
        for (var item : ToolTrimsItems.SMITHING_TEMPLATES.values()) {
            itemModelGenerator.method_25733(item, class_4943.field_22938);
        }

        for (var tool : standardTools) {
            var overrides = generateTrimmedOverrides(class_7923.field_41178.method_10221(tool), class_4943.field_22939, itemModelGenerator.field_22844);

            upload(class_4943.field_22939, tool, class_4944.method_25871(tool), itemModelGenerator.field_22844, overrides);
        }

        upload(class_4943.field_49915, class_1802.field_49814, class_4944.method_25871(class_1802.field_49814), itemModelGenerator.field_22844,
                generateTrimmedOverrides(class_7923.field_41178.method_10221(class_1802.field_49814), class_4943.field_49915, itemModelGenerator.field_22844));

        var bowOverrides = new JsonArray();
        var bowId = class_7923.field_41178.method_10221(class_1802.field_8102);
        generateTrimmedOverrides(bowOverrides, bowId, TEMPLATE_BOW, Map.of(), false, itemModelGenerator.field_22844);
        generateTrimmedOverrides(bowOverrides, bowId.method_48331("_pulling_0"), TEMPLATE_BOW, Map.of("pulling", 1), true, itemModelGenerator.field_22844);
        generateTrimmedOverrides(bowOverrides, bowId.method_48331("_pulling_1"), TEMPLATE_BOW, Map.of("pulling", 1, "pull", 0.65f), true, itemModelGenerator.field_22844);
        generateTrimmedOverrides(bowOverrides, bowId.method_48331("_pulling_2"), TEMPLATE_BOW, Map.of("pulling", 1, "pull", 0.9f), true, itemModelGenerator.field_22844);
        upload(TEMPLATE_BOW, class_1802.field_8102, class_4944.method_25871(class_1802.field_8102), itemModelGenerator.field_22844, bowOverrides);

        uploadCrossbow(itemModelGenerator, generateCrossbowOverrides(itemModelGenerator, true));
    }
}
