package archives.tater.tooltrims.item;

import archives.tater.tooltrims.ToolTrims;
import archives.tater.tooltrims.ToolTrimsPatterns;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_8052;
import net.minecraft.class_8056;
import java.util.Map;

import static archives.tater.tooltrims.item.ToolTrimSmithingTemplate.*;

public class ToolTrimsItems {

    private static class_1792 register(String path, class_1792 item) {
        return class_2378.method_10230(class_7923.field_41178, ToolTrims.id(path), item);
    }

    private static class_1792 registerToolTemplate(String name) {
        return register(name + "_tool_trim_smithing_template", new class_8052(
                APPLIES_TO_TEXT,
                INGREDIENTS_TEXT,
                class_2561.method_43471(class_156.method_646("tool_trim_pattern", ToolTrims.id(name))).method_27692(ToolTrimSmithingTemplate.TITLE_FORMATTING),
                BASE_SLOT_DESCRIPTION_TEXT,
                ADDITIONS_SLOT_DESCRIPTION_TEXT,
                getEmptyBaseSlotTextures(),
                getEmptyAdditionsSlotTextures()
        ));
    }

    public static final class_1792 LINEAR_TOOL_TRIM_SMITHING_TEMPLATE = registerToolTemplate("linear");
    public static final class_1792 TRACKS_TOOL_TRIM_SMITHING_TEMPLATE = registerToolTemplate("tracks");
    public static final class_1792 CHARGE_TOOL_TRIM_SMITHING_TEMPLATE = registerToolTemplate("charge");
    public static final class_1792 FROST_TOOL_TRIM_SMITHING_TEMPLATE = registerToolTemplate("frost");

    public static final Map<class_5321<class_8056>, class_1792> SMITHING_TEMPLATES = Map.of(
            ToolTrimsPatterns.LINEAR, LINEAR_TOOL_TRIM_SMITHING_TEMPLATE,
            ToolTrimsPatterns.TRACKS, TRACKS_TOOL_TRIM_SMITHING_TEMPLATE,
            ToolTrimsPatterns.CHARGE, CHARGE_TOOL_TRIM_SMITHING_TEMPLATE,
            ToolTrimsPatterns.FROST, FROST_TOOL_TRIM_SMITHING_TEMPLATE
    );

    public static void register() {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062).register(entries ->
            entries.addAfter(class_1802.field_49818,
                    LINEAR_TOOL_TRIM_SMITHING_TEMPLATE,
                    TRACKS_TOOL_TRIM_SMITHING_TEMPLATE,
                    CHARGE_TOOL_TRIM_SMITHING_TEMPLATE,
                    FROST_TOOL_TRIM_SMITHING_TEMPLATE)
        );
    }
}
