package archives.tater.tooltrims.mixin;

import archives.tater.tooltrims.loot.ReplaceablePools;
import com.google.common.collect.ImmutableList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.ArrayList;
import java.util.List;
import java.util.function.ObjLongConsumer;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_79;

import static com.google.common.collect.Streams.mapWithIndex;

@Mixin(class_52.class_53.class)
public class LootTableBuilderMixin implements ReplaceablePools {
    @Mutable
    @Shadow @Final private ImmutableList.Builder<class_55> pools;

    @Override
    public void tooltrims$modifyPoolEntries(ObjLongConsumer<List<class_79>> modifier) {
        var modified = new ArrayList<>(mapWithIndex(pools.build().stream(), (pool, index) -> {
            var accessor = (LootPoolAccessor) pool;

            var entries = new ArrayList<>(accessor.tooltrims$getEntries());
            modifier.accept(entries, index);

            return class_55.method_347()
                    .method_352(accessor.tooltrims$getRolls())
                    .method_35509(accessor.tooltrims$getBonusRolls())
                    .with(entries)
                    .conditionally(accessor.tooltrims$getConditions())
                    .apply(accessor.tooltrims$getFunctions())
                    .method_355();
        }).toList());
        pools = ImmutableList.builder();
        pools.addAll(modified);
    }
}
