package archives.tater.tooltrims.mixin.client;

import archives.tater.tooltrims.TridentTextures;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_756;

@Mixin(class_756.class)
public class BuiltinModelItemRendererMixin {
    @ModifyArg(
            method = "render",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/entity/model/TridentEntityModel;getLayer(Lnet/minecraft/util/Identifier;)Lnet/minecraft/client/render/RenderLayer;"),
            index = 0
    )
    private class_2960 applyTridentTrimTexture(class_2960 original, @Local(argsOnly = true) class_1799 stack) {
        return Objects.requireNonNullElse(TridentTextures.getTextureId(stack), original);
    }
}
