package archives.tater.tooltrims.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_763;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Debug(export = true)
@Mixin(class_918.class)
public class ItemRendererMixin {
    @Shadow @Final private class_763 models;

    @Shadow @Final public static class_1091 TRIDENT_IN_HAND;

    @ModifyExpressionValue(
            method = "getModel",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isOf(Lnet/minecraft/item/Item;)Z", ordinal = 0)
    )
    private boolean useDefaultTridentModel(boolean original) {
        return false;
    }

    @ModifyExpressionValue(
            method = "renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/render/model/json/ModelTransformationMode;ZLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/client/render/model/BakedModel;)V",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isOf(Lnet/minecraft/item/Item;)Z", ordinal = 0)
    )
    private boolean noOverrideTridentModel(boolean original) {
        return false;
    }

    @ModifyVariable(
            method = "renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/render/model/json/ModelTransformationMode;ZLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/client/render/model/BakedModel;)V",
            at = @At("HEAD"),
            argsOnly = true
    )
    private class_1087 overrideTridentModel(class_1087 original, @Local(argsOnly = true)class_1799 stack, @Local(argsOnly = true) class_811 renderMode) {
        if (renderMode == class_811.field_4317 || renderMode == class_811.field_4318 || renderMode == class_811.field_4319) return original;
        if (!stack.method_31574(class_1802.field_8547)) return original;
        return models.method_3303().method_4742(TRIDENT_IN_HAND);
    }
}
