package archives.tater.tooltrims.mixin.client;

import archives.tater.tooltrims.TridentTextures;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Objects;
import net.minecraft.class_1685;
import net.minecraft.class_2960;
import net.minecraft.class_955;

@Mixin(class_955.class)
public class TridentEntityRendererMixin {
    @ModifyReturnValue(
            method = "getTexture(Lnet/minecraft/entity/projectile/TridentEntity;)Lnet/minecraft/util/Identifier;",
            at = @At("RETURN")
    )
    private class_2960 applyTrimTexture(class_2960 original, @Local(argsOnly = true) class_1685 tridentEntity) {
        return Objects.requireNonNullElse(TridentTextures.getTextureId(tridentEntity), original);
    }
}
