/*
 * Decompiled with CFR 0.152.
 */
package com.knarfy.costumes.item;

import com.knarfy.costumes.procedures.WardenCostumeChestplateTickEventProcedure;
import com.knarfy.costumes.procedures.WardenCostumeHelmetTickEventProcedure;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.registries.DeferredHolder;

public abstract class WardenCostumeItem
extends Item {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(40, Map.of(ArmorType.BOOTS, 4, ArmorType.LEGGINGS, 7, ArmorType.CHESTPLATE, 8, ArmorType.HELMET, 4, ArmorType.BODY, 8), 9, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"entity.warden.heartbeat")), 5.0f, 0.0f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"costumes:warden_costume_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"costumes:warden_costume")));

    private WardenCostumeItem(Item.Properties properties) {
        super(properties);
    }

    public static class Boots
    extends WardenCostumeItem {
        public Boots(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.BOOTS));
        }
    }

    public static class Leggings
    extends WardenCostumeItem {
        public Leggings(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.LEGGINGS));
        }
    }

    public static class Chestplate
    extends WardenCostumeItem {
        public Chestplate(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.CHESTPLATE));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    WardenCostumeChestplateTickEventProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity);
                }
            }
        }
    }

    public static class Helmet
    extends WardenCostumeItem {
        public Helmet(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.HELMET));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    WardenCostumeHelmetTickEventProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity);
                }
            }
        }
    }
}

