/*
 * Decompiled with CFR 0.152.
 */
package com.knarfy.costumes.network;

import com.knarfy.costumes.CostumesMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class CostumesModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"costumes");

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CostumesMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
            if (mapdata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            WorldVariables worldVariables = WorldVariables.get((LevelAccessor)level2);
            if (worldVariables._syncDirty) {
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level2, (CustomPacketPayload)new SavedDataSyncMessage(1, worldVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                worldVariables._syncDirty = false;
            }
            MapVariables mapVariables = MapVariables.get((LevelAccessor)level2);
            if (mapVariables._syncDirty) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, mapVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                mapVariables._syncDirty = false;
            }
        }
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"costumes", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            SavedData patt0$temp = message.data;
            if (patt0$temp instanceof MapVariables) {
                MapVariables mapVariables = (MapVariables)patt0$temp;
                buffer.writeNbt((Tag)mapVariables.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            } else {
                SavedData patt1$temp = message.data;
                if (patt1$temp instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)patt1$temp;
                    buffer.writeNbt((Tag)worldVariables.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
                }
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(((MapVariables)message.data).save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(((WorldVariables)message.data).save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final SavedDataType<MapVariables> TYPE = new SavedDataType("costumes_mapvars", ctx -> new MapVariables(), ctx -> CompoundTag.CODEC.xmap(tag -> {
            MapVariables instance = new MapVariables();
            instance.read((CompoundTag)tag, (HolderLookup.Provider)ctx.levelOrThrow().registryAccess());
            return instance;
        }, instance -> instance.save(new CompoundTag(), (HolderLookup.Provider)ctx.levelOrThrow().registryAccess())));
        boolean _syncDirty = false;
        public double warden_sound_tick = 0.0;
        public double sniffer_sound_tick = 0.0;
        static MapVariables clientSide = new MapVariables();

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.warden_sound_tick = nbt.getDoubleOr("warden_sound_tick", 0.0);
            this.sniffer_sound_tick = nbt.getDoubleOr("sniffer_sound_tick", 0.0);
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("warden_sound_tick", this.warden_sound_tick);
            nbt.putDouble("sniffer_sound_tick", this.sniffer_sound_tick);
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAccessor.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(TYPE);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final SavedDataType<WorldVariables> TYPE = new SavedDataType("costumes_worldvars", ctx -> new WorldVariables(), ctx -> CompoundTag.CODEC.xmap(tag -> {
            WorldVariables instance = new WorldVariables();
            instance.read((CompoundTag)tag, (HolderLookup.Provider)ctx.levelOrThrow().registryAccess());
            return instance;
        }, instance -> instance.save(new CompoundTag(), (HolderLookup.Provider)ctx.levelOrThrow().registryAccess())));
        boolean _syncDirty = false;
        public double JoinPartyX = 0.0;
        public double JoinPartyY = 1000.0;
        public double JoinPartyZ = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.JoinPartyX = nbt.getDoubleOr("JoinPartyX", 0.0);
            this.JoinPartyY = nbt.getDoubleOr("JoinPartyY", 0.0);
            this.JoinPartyZ = nbt.getDoubleOr("JoinPartyZ", 0.0);
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("JoinPartyX", this.JoinPartyX);
            nbt.putDouble("JoinPartyY", this.JoinPartyY);
            nbt.putDouble("JoinPartyZ", this.JoinPartyZ);
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(TYPE);
            }
            return clientSide;
        }
    }
}

