/*
 * Decompiled with CFR 0.152.
 */
package de.jakomi1.easteraddition;

import com.mojang.logging.LogUtils;
import de.jakomi1.easteraddition.init.EasteradditionModBlocks;
import de.jakomi1.easteraddition.init.EasteradditionModEntities;
import de.jakomi1.easteraddition.init.EasteradditionModFluidTypes;
import de.jakomi1.easteraddition.init.EasteradditionModFluids;
import de.jakomi1.easteraddition.init.EasteradditionModItems;
import de.jakomi1.easteraddition.init.EasteradditionModPaintings;
import de.jakomi1.easteraddition.init.EasteradditionModParticleTypes;
import de.jakomi1.easteraddition.init.EasteradditionModTabs;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;

@Mod(value="easteraddition")
public class EasteradditionMod {
    public static final String MODID = "easteraddition";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("easteraddition", "easteraddition"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public EasteradditionMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        EasteradditionModBlocks.REGISTRY.register(modEventBus);
        EasteradditionModItems.REGISTRY.register(modEventBus);
        EasteradditionModEntities.REGISTRY.register(modEventBus);
        EasteradditionModTabs.REGISTRY.register(modEventBus);
        EasteradditionModPaintings.REGISTRY.register(modEventBus);
        EasteradditionModParticleTypes.REGISTRY.register(modEventBus);
        EasteradditionModFluids.REGISTRY.register(modEventBus);
        EasteradditionModFluidTypes.REGISTRY.register(modEventBus);
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common setup complete");
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Client setup complete");
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID++, messageType, encoder, decoder, messageConsumer);
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList<AbstractMap.SimpleEntry<Runnable, Integer>> toRun = new ArrayList<AbstractMap.SimpleEntry<Runnable, Integer>>();
            for (AbstractMap.SimpleEntry<Runnable, Integer> entry : workQueue) {
                entry.setValue(entry.getValue() - 1);
                if (entry.getValue() > 0) continue;
                toRun.add(entry);
            }
            toRun.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(toRun);
        }
    }
}

