/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia;

import com.stevekung.indicatia.config.IndicatiaConfig;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class Indicatia {
    public static final String MOD_ID = "indicatia";
    public static KeyMapping KEY_ALT_OPEN_CHAT;
    public static IndicatiaConfig CONFIG;
    private static final WidgetSprites RELOAD_BUTTON_SPRITES;
    private static final Component RELOAD_COMPONENT;

    public static void initConfig() {
        AutoConfig.register(IndicatiaConfig.class, GsonConfigSerializer::new);
        CONFIG = (IndicatiaConfig)AutoConfig.getConfigHolder(IndicatiaConfig.class).getConfig();
    }

    public static boolean canAddReloadButton(Screen screen) {
        return Indicatia.CONFIG.enableReloadResourcesButton && screen instanceof PackSelectionScreen && screen.getTitle().equals((Object)Component.translatable((String)"resourcePack.title"));
    }

    public static ImageButton getReloadResourcesButton(Screen screen, Minecraft minecraft) {
        ImageButton imageButton = new ImageButton(screen.width / 2 + 155, screen.height - 26, 20, 20, RELOAD_BUTTON_SPRITES, button -> minecraft.reloadResourcePacks(), RELOAD_COMPONENT);
        imageButton.setTooltip(Tooltip.create((Component)RELOAD_COMPONENT));
        return imageButton;
    }

    static {
        RELOAD_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"widget/reload"), ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"widget/reload_highlighted"));
        RELOAD_COMPONENT = Component.translatable((String)"menu.reload_resources");
    }
}

