/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffectInstance;

public class RenderUtils {
    private static final FontDescription UNIFORM = new FontDescription.Resource(Minecraft.UNIFORM_FONT);

    public static void renderPotionDurationOnTopRight(Font font, GuiGraphics guiGraphics, MobEffectInstance mobEffectInstance, int x, int y, float alpha, float ticksPerSecond) {
        boolean isInfinite = mobEffectInstance.isInfiniteDuration();
        int ticks = Mth.floor((float)mobEffectInstance.getDuration());
        MutableComponent component = isInfinite ? Component.translatable((String)"effect.duration.infinite") : Component.literal((String)StringUtil.formatTickDuration((int)ticks, (float)ticksPerSecond));
        MutableComponent text = component.withStyle(Style.EMPTY.withFont(isInfinite ? null : UNIFORM));
        int color = 0xFFFFFF | Mth.floor((float)(alpha * 255.0f)) << 24 & 0xFF000000;
        guiGraphics.drawCenteredString(font, (Component)text, x + 12, y + 15, color);
    }
}

