/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.combat.dps.DpsEvent;
import com.dee12452.gahoodrpg.common.combat.dps.DpsMeter;
import com.dee12452.gahoodrpg.common.combat.dps.PlayerDps;
import com.dee12452.gahoodrpg.common.items.IGahGeoItem;
import com.dee12452.gahoodrpg.common.items.armor.IGahArmor;
import com.dee12452.gahoodrpg.utils.ItemUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class GahoodRPGClient {
    private static GahoodRPGClient instance;
    @Nullable
    private Player clientPlayer = null;
    @Nullable
    private SoundManager soundManager = null;
    private ScreenType screenType = ScreenType.NONE;
    private final Map<String, PlayerDps> playerDps = new HashMap<String, PlayerDps>();
    private ProgressBarType progressBarType = ProgressBarType.NONE;
    private final Map<String, Object> customItemClientExtensions = new HashMap<String, Object>();

    public static GahoodRPGClient getInstance() {
        if (instance == null) {
            instance = new GahoodRPGClient();
        }
        return instance;
    }

    private GahoodRPGClient() {
    }

    @Nullable
    public Player getClientPlayer() {
        return this.clientPlayer;
    }

    public void setClientPlayer(@Nullable Player clientPlayer) {
        this.clientPlayer = clientPlayer;
    }

    @Nullable
    public SoundManager getSoundManager() {
        return this.soundManager;
    }

    public void setSoundManager(@Nullable SoundManager soundManager) {
        this.soundManager = soundManager;
    }

    public ScreenType getScreenType() {
        return this.screenType;
    }

    public void setScreenType(ScreenType screenType) {
        this.screenType = screenType;
    }

    public Optional<Pair<String, PlayerDps>> getClientPlayerDps() {
        Player clientPlayer = this.getClientPlayer();
        if (clientPlayer == null) {
            return Optional.empty();
        }
        String name = clientPlayer.m_7755_().getString();
        if (this.playerDps.containsKey(name)) {
            return Optional.of(Pair.of((Object)name, (Object)this.playerDps.get(name)));
        }
        CommonPlayerCapability caps = Capabilities.commonPlayer(clientPlayer);
        Optional<UUID> roleId = caps.getCurrentRoleId();
        return roleId.map(uuid -> Pair.of((Object)name, (Object)new PlayerDps((UUID)uuid, new DpsMeter())));
    }

    public List<Pair<String, PlayerDps>> getAllPlayerDps() {
        return this.playerDps.entrySet().stream().map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((PlayerDps)entry.getValue()))).sorted(Comparator.comparingDouble(pair -> ((PlayerDps)pair.getValue()).dpsMeter().calculate())).toList();
    }

    public void updatePlayerDps(DpsEvent event) {
        PlayerDps dps;
        String playerName = event.playerName();
        if (!this.playerDps.containsKey(playerName)) {
            this.playerDps.put(playerName, new PlayerDps(event.roleId(), new DpsMeter()));
        }
        if (!(dps = this.playerDps.get(playerName)).roleId().equals(event.roleId())) {
            dps = new PlayerDps(event.roleId(), dps.dpsMeter());
            this.playerDps.put(playerName, dps);
        }
        dps.dpsMeter().addEvent(event);
    }

    public ProgressBarType getProgressBarType() {
        return this.progressBarType;
    }

    public void setProgressBarType(ProgressBarType progressBarType) {
        this.progressBarType = progressBarType;
    }

    public void registerItemClientExtension(IGahGeoItem item, Object clientExtension) {
        this.customItemClientExtensions.put(item.getId(), clientExtension);
    }

    public Object getItemClientExtension(IGahGeoItem item) {
        return this.getItemClientExtension(item.getId());
    }

    public Object getItemClientExtension(String key) {
        if (!this.customItemClientExtensions.containsKey(key)) {
            String exMessage = String.format("Could not find client item renderer %s, verify it was registered in ItemClientExtensionListener", key);
            throw new IllegalStateException(exMessage);
        }
        return this.customItemClientExtensions.get(key);
    }

    public static String createArmorItemClientExtensionKey(IGahArmor armor) {
        return String.format("%s_%s", armor.getGahMaterial().name().toLowerCase(), ItemUtils.toSlotName(armor.m_40402_()));
    }

    public static enum ScreenType {
        NONE,
        MASTERY_BOOK;

    }

    public static enum ProgressBarType {
        NONE,
        FROST_BLAST,
        POWER_SLASH;

    }
}

