/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.curios;

import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public abstract class CuriosModelProvider {
    private final ResourceLocation modelLocation;
    private final Function<ModelPart, Model> modelCreator;
    private final int textureWidth;
    private final int textureHeight;

    public CuriosModelProvider(String modelLocation, Function<ModelPart, Model> modelCreator, int textureWidth, int textureHeight) {
        this.modelLocation = new ResourceLocationBuilder(modelLocation).named();
        this.modelCreator = modelCreator;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public Model createModel(Supplier<EntityModelSet> modelSet) {
        return this.modelCreator.apply(modelSet.get().m_171103_(this.createModelLocation()));
    }

    public ModelLayerLocation createModelLocation() {
        return new ModelLayerLocation(this.modelLocation, "main");
    }

    public LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        this.addDefinitions(partdefinition);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)this.textureWidth, (int)this.textureHeight);
    }

    protected abstract void addDefinitions(PartDefinition var1);
}

