/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.entities.block;

import com.dee12452.gahoodrpg.client.entities.block.AnimatedBlockEntityRendererBase;
import com.dee12452.gahoodrpg.common.blocks.HordeSpawnerBlock;
import com.dee12452.gahoodrpg.common.entities.block.horde.HordeDifficulty;
import com.dee12452.gahoodrpg.common.entities.block.horde.HordeLocation;
import com.dee12452.gahoodrpg.common.entities.block.horde.HordeSpawnerBlockEntity;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import java.util.Locale;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;

public class HordeSpawnerRenderer
extends AnimatedBlockEntityRendererBase<HordeSpawnerBlockEntity> {
    private static final ResourceLocation MODEL_RESOURCE = new ResourceLocationBuilder("horde_spawner").named();
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocationBuilder("horde_spawner_tier1_easy_all").named();

    public HordeSpawnerRenderer(BlockEntityRendererProvider.Context context) {
        super(context, new HordeSpawnerModel());
    }

    private static class HordeSpawnerModel
    extends DefaultedBlockGeoModel<HordeSpawnerBlockEntity> {
        public HordeSpawnerModel() {
            super(MODEL_RESOURCE);
            this.withAltTexture(DEFAULT_TEXTURE);
        }

        public RenderType getRenderType(HordeSpawnerBlockEntity animatable, ResourceLocation texture) {
            BlockState blockState = animatable.m_58900_();
            int tier = (Integer)blockState.m_61143_((Property)HordeSpawnerBlock.HORDE_TIER);
            String difficulty = HordeDifficulty.fromBlockState(blockState).name().toLowerCase(Locale.ENGLISH);
            String location = HordeLocation.fromBlockState(blockState).name().toLowerCase(Locale.ENGLISH);
            String textureName = String.format("horde_spawner_tier%d_%s_%s", tier, difficulty, location);
            return RenderType.m_110473_((ResourceLocation)new ResourceLocationBuilder(textureName).block());
        }
    }
}

