/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.entities.projectile;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;

public abstract class CustomProjectileRendererBase<T extends Projectile>
extends EntityRenderer<T> {
    private final EntityModel<T> model;
    protected List<RenderLayer<T, EntityModel<T>>> layers = Lists.newArrayList();
    protected float rotationOffset = 180.0f;

    public CustomProjectileRendererBase(EntityRendererProvider.Context context, EntityModel<T> model) {
        super(context);
        this.model = model;
    }

    public void render(@NotNull T entity, float p_115309_, float p_115310_, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int p_115313_) {
        this.renderModel(entity, p_115310_, poseStack, multiBufferSource, p_115313_);
        super.m_7392_(entity, p_115309_, p_115310_, poseStack, multiBufferSource, p_115313_);
    }

    private void renderModel(T entity, float p_115310_, PoseStack poseStack, MultiBufferSource multiBufferSource, int p_115313_) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        poseStack.m_85836_();
        float f = entity.m_146908_();
        float f2 = entity.m_146909_();
        float f7 = this.getBob((Entity)entity, p_115310_);
        Matrix4f rotationMatrix = new Matrix4f();
        rotationMatrix.rotateY((float)Math.toRadians(f - this.rotationOffset));
        rotationMatrix.rotateX((float)Math.toRadians(f2));
        Quaternionf rotationQuaternion = new Quaternionf().setFromUnnormalized((Matrix4fc)rotationMatrix);
        poseStack.m_252781_(rotationQuaternion);
        poseStack.m_85837_(0.0, -1.501, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        this.model.m_6839_(entity, f5, f8, p_115310_);
        this.model.m_6973_(entity, f5, f8, f7, f2, 0.0f);
        boolean flag = !entity.m_20145_();
        boolean flag1 = !flag && !entity.m_20177_((Player)player);
        boolean flag2 = minecraft.m_91314_(entity);
        RenderType rendertype = this.getRenderType(entity, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = multiBufferSource.m_6299_(rendertype);
            int i = this.getOverlayCoords(entity, 0.0f);
            this.model.m_7695_(poseStack, vertexconsumer, p_115313_, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!entity.m_5833_()) {
            for (RenderLayer<T, EntityModel<T>> renderlayer : this.layers) {
                renderlayer.m_6494_(poseStack, multiBufferSource, p_115313_, entity, f5, f8, p_115310_, f7, f2, 0.0f);
            }
        }
        poseStack.m_85849_();
    }

    private float getBob(Entity p_115305_, float p_115306_) {
        return (float)p_115305_.f_19797_ + p_115306_;
    }

    @Nullable
    private RenderType getRenderType(T p_115322_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        ResourceLocation resourcelocation = this.m_5478_((Entity)p_115322_);
        if (p_115324_) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (p_115323_) {
            return this.model.m_103119_(resourcelocation);
        }
        return p_115325_ ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    private int getOverlayCoords(T p_115339_, float p_115340_) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)p_115340_), (int)OverlayTexture.m_118096_((boolean)false));
    }
}

