/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.entities.projectile;

import com.dee12452.gahoodrpg.client.entities.projectile.GeoProjectileRendererBase;
import com.dee12452.gahoodrpg.common.entities.projectile.GuardianShield;
import com.dee12452.gahoodrpg.common.items.weapons.GahShieldItem;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.GeoModel;

public class GuardianShieldRenderer
extends GeoProjectileRendererBase<GuardianShield> {
    private static final ResourceLocation TEXTURE = new ResourceLocationBuilder("guardian_shield").named();
    @Nullable
    private ShieldItemEntityModel shieldModel;

    public GuardianShieldRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new DefaultedEntityGeoModel(TEXTURE));
    }

    public GeoModel<GuardianShield> getGeoModel() {
        Optional<GahShieldItem> shieldItem = ((GuardianShield)this.animatable).getItem();
        if (shieldItem.isEmpty()) {
            this.shieldModel = null;
            return super.getGeoModel();
        }
        if (this.shieldModel == null || this.shieldModel.shieldId != Item.m_41393_((Item)((Item)shieldItem.get()))) {
            this.shieldModel = new ShieldItemEntityModel(shieldItem.get());
        }
        return this.shieldModel;
    }

    @Override
    public void actuallyRender(PoseStack poseStack, GuardianShield animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.shieldModel != null && !isReRender) {
            poseStack.m_85836_();
            float motionThreshold = this.getMotionAnimThreshold((GeoAnimatable)animatable);
            Vec3 velocity = animatable.m_20184_();
            float avgVelocity = (float)(Math.abs(velocity.f_82479_) + Math.abs(velocity.f_82481_)) / 2.0f;
            AnimationState animationState = new AnimationState((GeoAnimatable)animatable, 0.0f, 0.0f, partialTick, avgVelocity >= motionThreshold);
            long instanceId = this.getInstanceId((Entity)animatable);
            animationState.setData(DataTickets.TICK, (Object)animatable.getTick((Object)animatable));
            animationState.setData(DataTickets.ENTITY, (Object)animatable);
            this.shieldModel.addAdditionalStateData((GeoAnimatable)animatable, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
            this.shieldModel.handleAnimations((GeoAnimatable)animatable, instanceId, animationState);
            poseStack.m_85849_();
        }
        super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private static class ShieldItemEntityModel
    extends DefaultedEntityGeoModel<GuardianShield> {
        int shieldId;

        public ShieldItemEntityModel(GahShieldItem shield) {
            super(TEXTURE);
            this.withAltModel(shield.createModelResourceLocation());
            this.withAltTexture(shield.createTextureResourceLocation());
            this.shieldId = Item.m_41393_((Item)shield);
        }

        public ResourceLocation buildFormattedAnimationPath(ResourceLocation basePath) {
            return new ResourceLocation(basePath.m_135827_(), "animations/entity/" + basePath.m_135815_() + ".animation.json");
        }

        protected String subtype() {
            return "item";
        }

        public boolean crashIfBoneMissing() {
            return true;
        }
    }
}

