/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.events.listeners;

import com.dee12452.gahoodrpg.client.GahoodRPGClient;
import com.dee12452.gahoodrpg.common.events.listeners.EventListenerBase;
import com.dee12452.gahoodrpg.common.items.IGahGeoItem;
import com.dee12452.gahoodrpg.common.items.armor.GahArmors;
import com.dee12452.gahoodrpg.common.items.armor.GahGeoArmorItem;
import com.dee12452.gahoodrpg.common.items.blocks.GahBlocks;
import com.dee12452.gahoodrpg.common.items.curios.GahTrinkets;
import com.dee12452.gahoodrpg.common.items.weapons.GahWeapons;
import com.dee12452.gahoodrpg.common.items.weapons.IGahGeoWeapon;
import java.util.function.Supplier;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoItemRenderer;

@OnlyIn(value=Dist.CLIENT)
public class ItemClientExtensionListener
extends EventListenerBase<FMLClientSetupEvent> {
    public ItemClientExtensionListener(FMLClientSetupEvent event) {
        super(event);
    }

    @Override
    public void onEvent() {
        GahWeapons.getAll().stream().filter(weapon -> weapon instanceof IGahGeoWeapon).map(weapon -> (Item)((IGahGeoWeapon)weapon)).forEach(x$0 -> ItemClientExtensionListener.registerItemRenderer((Item)x$0));
        GahArmors.getAll().stream().filter(item -> item.getLeft() instanceof GahGeoArmorItem).map(item -> (GahGeoArmorItem)item.getLeft()).forEach(ItemClientExtensionListener::registerArmorItemRenderer);
        GahBlocks.getAll().stream().filter(item -> item instanceof IGahGeoItem).map(item -> (BlockItem)((IGahGeoItem)item)).forEach(x$0 -> ItemClientExtensionListener.registerBlockItemRenderer((BlockItem)x$0));
        GahTrinkets.getAll().stream().filter(item -> item instanceof IGahGeoItem).map(item -> (Item)((IGahGeoItem)item)).forEach(x$0 -> ItemClientExtensionListener.registerItemRenderer((Item)x$0));
    }

    private static <T extends GahGeoArmorItem> void registerArmorItemRenderer(T item) {
        Supplier itemRenderer = () -> new GeoItemRenderer((GeoModel)new DefaultedItemGeoModel(item.createModelResourceLocation()).withAltTexture(item.createTextureResourceLocation()).withAltAnimations(item.createTextureResourceLocation()));
        Supplier armorRenderer = () -> new GeoArmorRenderer((GeoModel)new DefaultedItemGeoModel(item.createTextureResourceLocation()));
        GahoodRPGClient.getInstance().registerItemClientExtension(item, new GahGeoItemClientExtension(itemRenderer, armorRenderer));
    }

    private static <T extends Item> void registerItemRenderer(T item) {
        Supplier itemRenderer = () -> new GeoItemRenderer((GeoModel)new DefaultedItemGeoModel(((IGahGeoItem)item).createModelResourceLocation()).withAltTexture(((IGahGeoItem)item).createTextureResourceLocation()));
        GahoodRPGClient.getInstance().registerItemClientExtension((IGahGeoItem)item, new GahGeoItemClientExtension(itemRenderer));
    }

    private static <T extends BlockItem> void registerBlockItemRenderer(T item) {
        Supplier itemRenderer = () -> new GeoItemRenderer((GeoModel)new DefaultedBlockGeoModel(((IGahGeoItem)item).createModelResourceLocation()).withAltTexture(((IGahGeoItem)item).createTextureResourceLocation()));
        GahoodRPGClient.getInstance().registerItemClientExtension((IGahGeoItem)item, new GahGeoItemClientExtension(itemRenderer));
    }

    private static class GahGeoItemClientExtension<I extends Item, A extends ArmorItem>
    implements IClientItemExtensions {
        private GeoItemRenderer<I> itemRenderer;
        private final Supplier<GeoItemRenderer<I>> itemRendererSupplier;
        private GeoArmorRenderer<A> armorRenderer;
        @Nullable
        private final Supplier<GeoArmorRenderer<A>> armorRendererSupplier;

        public GahGeoItemClientExtension(Supplier<GeoItemRenderer<I>> itemRendererSupplier) {
            this(itemRendererSupplier, null);
        }

        public GahGeoItemClientExtension(Supplier<GeoItemRenderer<I>> itemRendererSupplier, @Nullable Supplier<GeoArmorRenderer<A>> armorRendererSupplier) {
            this.itemRendererSupplier = itemRendererSupplier;
            this.armorRendererSupplier = armorRendererSupplier;
        }

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            if (this.itemRenderer == null) {
                this.itemRenderer = this.itemRendererSupplier.get();
            }
            return this.itemRenderer;
        }

        @NotNull
        public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
            if (this.armorRenderer == null) {
                if (this.armorRendererSupplier == null) {
                    return original;
                }
                this.armorRenderer = this.armorRendererSupplier.get();
            }
            this.armorRenderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
            return this.armorRenderer;
        }
    }
}

