/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.events.listeners;

import com.dee12452.gahoodrpg.client.GahoodRPGClient;
import com.dee12452.gahoodrpg.client.events.listeners.RegisterKeyMappingsListener;
import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.ClientPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.role.IGahRole;
import com.dee12452.gahoodrpg.common.capabilities.spell.IGahSpell;
import com.dee12452.gahoodrpg.common.events.listeners.EventListenerBase;
import com.dee12452.gahoodrpg.common.items.curios.IActionTrinket;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.INetworkMessage;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerInventorySwap;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerOpenMasteryBook;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerPressJump;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerPressSpell;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerPressTrinketAction;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerReleaseJump;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerReleaseSpell;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.RoleUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.InputEvent;

public class KeyInputListener
extends EventListenerBase<InputEvent.Key> {
    public KeyInputListener(InputEvent.Key event) {
        super(event);
    }

    @Override
    public void onEvent() {
        if (!KeyInputListener.canUseKeybinds()) {
            return;
        }
        if (((InputEvent.Key)this.event).getAction() == 1) {
            this.checkKeyPress(((InputEvent.Key)this.event).getKey());
        } else if (((InputEvent.Key)this.event).getAction() == 0) {
            this.checkKeyRelease(((InputEvent.Key)this.event).getKey());
        }
    }

    private void checkKeyPress(int key) {
        Player player = GahoodRPGClient.getInstance().getClientPlayer();
        CommonPlayerCapability cap = Capabilities.commonPlayer(player);
        Optional<IGahRole> role = cap.getCurrentRole();
        role.ifPresent(iGahRole -> KeyInputListener.checkSpellPress(key, iGahRole, cap, player));
        if (key == RegisterKeyMappingsListener.MAIN_HAND_SWAP_KEYBOARD_MAPPING.getKey().m_84873_()) {
            KeyInputListener.performWeaponSwap();
        } else if (key == RegisterKeyMappingsListener.OPEN_MASTERY_BOOK_KEYBOARD_MAPPING.getKey().m_84873_()) {
            NetworkChannel.sendToServer(new ServerOpenMasteryBook.Message());
        } else if (key == RegisterKeyMappingsListener.TRINKET_ACTION_KEYBOARD_MAPPING.getKey().m_84873_()) {
            KeyInputListener.onTrinketActionButton(IActionTrinket::onTrinketActionPressed, new ServerPressTrinketAction.Message());
        } else if (key == Minecraft.m_91087_().f_91066_.f_92089_.getKey().m_84873_()) {
            RoleUtils.getUsableSpells(player).forEach(spell -> spell.onJump(player));
            KeyInputListener.onTrinketActionButton(IActionTrinket::onJumpPressed, new ServerPressJump.Message());
        }
    }

    private static void checkSpellPress(int key, IGahRole role, CommonPlayerCapability cap, Player player) {
        UUID spellId;
        if (key == RegisterKeyMappingsListener.SPELL_ONE_MAPPING.getKey().m_84873_()) {
            spellId = role.getPrimarySpellIds().get(0);
        } else if (key == RegisterKeyMappingsListener.SPELL_TWO_MAPPING.getKey().m_84873_()) {
            spellId = role.getPrimarySpellIds().get(1);
        } else if (key == RegisterKeyMappingsListener.SPELL_THREE_MAPPING.getKey().m_84873_()) {
            spellId = role.getPrimarySpellIds().get(2);
        } else if (key == RegisterKeyMappingsListener.SPELL_FOUR_MAPPING.getKey().m_84873_()) {
            spellId = role.getPrimarySpellIds().get(3);
        } else {
            return;
        }
        IGahSpell spell = cap.getSpell(spellId);
        if (!spell.canUse() || player.m_5833_()) {
            return;
        }
        spell.onActivateSpell(player);
        NetworkChannel.sendToServer(new ServerPressSpell.Message(spellId));
    }

    private void checkKeyRelease(int key) {
        UUID spellId;
        Player player;
        CommonPlayerCapability cap;
        Optional<IGahRole> role;
        if (key == Minecraft.m_91087_().f_91066_.f_92089_.getKey().m_84873_()) {
            KeyInputListener.onTrinketActionButton(IActionTrinket::onJumpReleased, new ServerReleaseJump.Message());
        }
        if ((role = (cap = Capabilities.commonPlayer(player = GahoodRPGClient.getInstance().getClientPlayer())).getCurrentRole()).isEmpty()) {
            return;
        }
        if (key == RegisterKeyMappingsListener.SPELL_ONE_MAPPING.getKey().m_84873_()) {
            spellId = role.get().getPrimarySpellIds().get(0);
        } else if (key == RegisterKeyMappingsListener.SPELL_TWO_MAPPING.getKey().m_84873_()) {
            spellId = role.get().getPrimarySpellIds().get(1);
        } else if (key == RegisterKeyMappingsListener.SPELL_THREE_MAPPING.getKey().m_84873_()) {
            spellId = role.get().getPrimarySpellIds().get(2);
        } else if (key == RegisterKeyMappingsListener.SPELL_FOUR_MAPPING.getKey().m_84873_()) {
            spellId = role.get().getPrimarySpellIds().get(3);
        } else {
            return;
        }
        IGahSpell spell = cap.getSpell(spellId);
        if (!spell.canUse() || player == null || player.m_5833_()) {
            return;
        }
        spell.onReleaseSpell(player);
        NetworkChannel.sendToServer(new ServerReleaseSpell.Message(spellId));
    }

    private static void onTrinketActionButton(TrinketActionConsumer action, INetworkMessage networkMessage) {
        Player player = GahoodRPGClient.getInstance().getClientPlayer();
        EntityUtils.getCuriosSlots((LivingEntity)player).stream().filter(slot -> slot.stack().m_41720_() instanceof IActionTrinket).forEach(slot -> action.consume((IActionTrinket)slot.stack().m_41720_(), player, slot.stack()));
        NetworkChannel.sendToServer(networkMessage);
    }

    private static void performWeaponSwap() {
        if (Minecraft.m_91087_().f_91080_ instanceof InventoryScreen) {
            return;
        }
        Player player = GahoodRPGClient.getInstance().getClientPlayer();
        if (player == null) {
            return;
        }
        ClientPlayerCapability clientPlayerCap = Capabilities.clientPlayer(player);
        CommonPlayerCapability playerCapability = Capabilities.commonPlayer(player);
        if (!clientPlayerCap.getSwapCooldown().checkAndReset((LivingEntity)player)) {
            return;
        }
        int mainHandSlotItem = playerCapability.getMainHandSwapItemId();
        int offHandSlotItem = playerCapability.getOffHandSwapItemId();
        NetworkChannel.sendToServer(new ServerInventorySwap.Message(mainHandSlotItem, offHandSlotItem));
    }

    private static boolean canUseKeybinds() {
        return GahoodRPGClient.getInstance().getClientPlayer() != null && Minecraft.m_91087_().f_91080_ == null;
    }

    @FunctionalInterface
    private static interface TrinketActionConsumer {
        public void consume(IActionTrinket var1, Player var2, ItemStack var3);
    }
}

