/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.events.listeners;

import com.dee12452.gahoodrpg.client.curios.CuriosBodyRenderer;
import com.dee12452.gahoodrpg.client.curios.amulet.StatsCharmModelProvider;
import com.dee12452.gahoodrpg.client.curios.back.CapeModelProvider;
import com.dee12452.gahoodrpg.client.curios.back.EnderWingsModelProvider;
import com.dee12452.gahoodrpg.client.curios.belt.HealBeltModelProvider;
import com.dee12452.gahoodrpg.client.curios.belt.HomeboundBeltModelProvider;
import com.dee12452.gahoodrpg.client.curios.belt.MinersBeltModelProvider;
import com.dee12452.gahoodrpg.common.events.listeners.EventListenerBase;
import com.dee12452.gahoodrpg.common.items.Items;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

public class RegisterCuriosRenderersListener
extends EventListenerBase<FMLClientSetupEvent> {
    public RegisterCuriosRenderersListener(FMLClientSetupEvent event) {
        super(event);
    }

    @Override
    public void onEvent() {
        this.registerBelts();
        this.registerBacks();
        this.registerAmulets();
    }

    private void registerBelts() {
        CuriosRendererRegistry.register((Item)((Item)Items.HOMEBOUND_BELT.get()), () -> new CuriosBodyRenderer(new HomeboundBeltModelProvider(), new ResourceLocationBuilder("homebound_belt").curios()));
        CuriosRendererRegistry.register((Item)((Item)Items.MINERS_BELT.get()), () -> new CuriosBodyRenderer(new MinersBeltModelProvider(), new ResourceLocationBuilder("miners_belt").curios()));
        CuriosRendererRegistry.register((Item)((Item)Items.HEAL_BELT.get()), () -> new CuriosBodyRenderer(new HealBeltModelProvider(), new ResourceLocationBuilder("heal_belt").curios()));
    }

    private void registerBacks() {
        this.registerCapes();
        CuriosRendererRegistry.register((Item)((Item)Items.ENDER_WINGS.get()), () -> new CuriosBodyRenderer(new EnderWingsModelProvider(), new ResourceLocationBuilder("ender_wings").curios()));
    }

    private void registerAmulets() {
        CuriosRendererRegistry.register((Item)((Item)Items.POWER_CHARM_V1.get()), () -> new CuriosBodyRenderer(new StatsCharmModelProvider(), new ResourceLocationBuilder("power_charm_v1").curios()));
        CuriosRendererRegistry.register((Item)((Item)Items.POWER_CHARM_V2.get()), () -> new CuriosBodyRenderer(new StatsCharmModelProvider(), new ResourceLocationBuilder("power_charm_v2").curios()));
        CuriosRendererRegistry.register((Item)((Item)Items.POWER_CHARM_V3.get()), () -> new CuriosBodyRenderer(new StatsCharmModelProvider(), new ResourceLocationBuilder("power_charm_v3").curios()));
    }

    private void registerCapes() {
        ArrayList capeColors = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"black", (Object)((Item)Items.BLACK_CAPE.get())), Pair.of((Object)"blue", (Object)((Item)Items.BLUE_CAPE.get())), Pair.of((Object)"green", (Object)((Item)Items.GREEN_CAPE.get())), Pair.of((Object)"gray", (Object)((Item)Items.GRAY_CAPE.get())), Pair.of((Object)"orange", (Object)((Item)Items.ORANGE_CAPE.get())), Pair.of((Object)"pink", (Object)((Item)Items.PINK_CAPE.get())), Pair.of((Object)"purple", (Object)((Item)Items.PURPLE_CAPE.get())), Pair.of((Object)"red", (Object)((Item)Items.RED_CAPE.get())), Pair.of((Object)"white", (Object)((Item)Items.WHITE_CAPE.get())), Pair.of((Object)"yellow", (Object)((Item)Items.YELLOW_CAPE.get()))});
        CapeModelProvider capeModel = new CapeModelProvider();
        for (Pair cape : capeColors) {
            ResourceLocation texture = new ResourceLocationBuilder(String.format("%s_cape", cape.getLeft())).curios();
            CuriosRendererRegistry.register((Item)((Item)cape.getRight()), () -> new CuriosBodyRenderer(capeModel, texture));
        }
    }
}

