/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.screens;

import com.dee12452.gahoodrpg.client.GahoodRPGConfig;
import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerSetOptions;
import com.dee12452.gahoodrpg.utils.ColorUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class GahoodRPGConfigScreen
extends Screen {
    private final Player player;
    private final boolean isLevelUnavailable;
    private final Font font;
    private Button dpsMeterEnabledButton;
    private PvpEnabledButton pvpEnabledButton;

    public GahoodRPGConfigScreen(Minecraft minecraft) {
        super((Component)Component.m_237115_((String)"mod.gahoodrpg.name"));
        this.player = minecraft.f_91074_;
        this.isLevelUnavailable = minecraft.f_91073_ == null;
        this.font = minecraft.f_91062_;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.isLevelUnavailable) {
            return;
        }
        this.dpsMeterEnabledButton = this.createDpsMeterButton();
        this.m_142416_((GuiEventListener)this.dpsMeterEnabledButton);
        this.pvpEnabledButton = new PvpEnabledButton(this.player);
        this.m_142416_((GuiEventListener)this.pvpEnabledButton);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.isLevelUnavailable) {
            return;
        }
        boolean isPvpEnabled = GahoodRPGConfigScreen.getConfig(this.player).isPvpEnabled();
        if (isPvpEnabled != this.pvpEnabledButton.isPvpEnabled()) {
            this.m_169411_((GuiEventListener)this.pvpEnabledButton);
            this.pvpEnabledButton = new PvpEnabledButton(this.player);
            this.m_142416_((GuiEventListener)this.pvpEnabledButton);
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int p_281550_, int p_282878_, float p_282465_) {
        super.m_88315_(graphics, p_281550_, p_282878_, p_282465_);
        if (this.isLevelUnavailable) {
            GahoodRPGConfigScreen.writeTextCenter(this, graphics, this.font, (Component)Component.m_237115_((String)"screen.gahoodrpg.config.no_level_available"), 1);
        } else {
            GahoodRPGConfigScreen.writeTextCenter(this, graphics, this.font, (Component)Component.m_237115_((String)"screen.gahoodrpg.config.options_title"), 1);
        }
    }

    private Button createDpsMeterButton() {
        String buttonText = GahoodRPGConfigScreen.getConfig(this.player).isDpsMeterEnabled() ? "options.gahoodrpg.dps_meter_enabled" : "options.gahoodrpg.dps_meter_disabled";
        return Button.m_253074_((Component)Component.m_237115_((String)buttonText), this::onDpsMeterButtonClick).m_252794_(10, 40).m_252780_(150).m_253136_();
    }

    private void onDpsMeterButtonClick(Button button) {
        GahoodRPGConfig config;
        config.setDpsMeterEnabled(!(config = GahoodRPGConfigScreen.getConfig(this.player)).isDpsMeterEnabled());
        this.m_169411_((GuiEventListener)button);
        this.dpsMeterEnabledButton = this.createDpsMeterButton();
        this.m_142416_((GuiEventListener)this.dpsMeterEnabledButton);
    }

    private static GahoodRPGConfig getConfig(Player player) {
        return Capabilities.clientPlayer(player).getConfig();
    }

    public static void writeTextCenter(Screen screen, GuiGraphics graphics, Font f, Component text, int lineNumber) {
        int n = screen.f_96543_ / 2 - f.m_92852_((FormattedText)text) / 2;
        int n2 = screen.f_96544_ / 2;
        Objects.requireNonNull(f);
        graphics.m_280614_(f, text, n, n2 + 9 * lineNumber, ColorUtils.hexToRgb24("#FFFFFF"), false);
    }

    private static class PvpEnabledButton
    extends Button {
        private final boolean pvpEnabled;

        public PvpEnabledButton(Player player) {
            super(Button.m_253074_((Component)Component.m_237115_((String)PvpEnabledButton.getButtonText(player)), btn -> PvpEnabledButton.onPvpEnabledButtonClick(player)).m_252794_(10, 70).m_252780_(150));
            this.pvpEnabled = GahoodRPGConfigScreen.getConfig(player).isPvpEnabled();
        }

        public boolean isPvpEnabled() {
            return this.pvpEnabled;
        }

        private static String getButtonText(Player player) {
            return GahoodRPGConfigScreen.getConfig(player).isPvpEnabled() ? "options.gahoodrpg.pvp_enabled" : "options.gahoodrpg.pvp_disabled";
        }

        private static void onPvpEnabledButtonClick(Player player) {
            NetworkChannel.sendToServer(new ServerSetOptions.Message(!GahoodRPGConfigScreen.getConfig(player).isPvpEnabled()));
        }
    }
}

