/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.screens.masterybook;

import com.dee12452.gahoodrpg.client.screens.masterybook.MasteryBookPage;
import com.dee12452.gahoodrpg.common.capabilities.role.IGahRole;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public abstract class ExperiencePageBase
extends MasteryBookPage {
    public ExperiencePageBase(Player player, Supplier<Font> font, Consumer<Button> buttonAdder, Consumer<Button> buttonRemover) {
        super(player, font, buttonAdder, buttonRemover);
    }

    protected void runRenderExperienceTooltip(GuiGraphics graphics, Font font, IGahRole role, int mouseX, int mouseY) {
        int currLevel = role.getLevel();
        int nextLevelXP = role.calculateExperienceTo(currLevel + 1);
        int currXP = role.getExperience();
        String text = String.format("%d / %d", currXP, nextLevelXP);
        graphics.m_280557_(font, (Component)Component.m_237113_((String)text), mouseX, mouseY);
    }

    protected Button createPlusButton(Screen screen, int i, int size, Button.OnPress onPress) {
        int buttonSide = 20;
        int buttonSpellYOffset = 5;
        int sidePixels = 32;
        int startX = ExperiencePageBase.bookStartX(screen) + 25;
        int offsetX = 256 / size - 5;
        int spellX = startX + offsetX * i;
        int spellBubbleY = ExperiencePageBase.bookEndY(screen) / 2;
        return Button.m_253074_((Component)Component.m_237113_((String)"+"), (Button.OnPress)onPress).m_252794_(spellX + 16 - 10, spellBubbleY + 32 + 5).m_253046_(20, 20).m_253136_();
    }

    protected boolean drawExperienceBar(Screen screen, GuiGraphics graphics, IGahRole role, int mouseX, int mouseY) {
        int experienceW = 91;
        int experienceH = 5;
        int startY = ExperiencePageBase.bookEndY(screen) - 52;
        int startX = ExperiencePageBase.bookMiddleX(screen) - 45;
        graphics.m_280163_(EXPERIENCE_BAR_EMPTY_RESOURCE_LOCATION, startX, startY, 0.0f, 0.0f, 91, 5, 91, 5);
        graphics.m_280163_(EXPERIENCE_BAR_FILLED_RESOURCE_LOCATION, startX, startY, 0.0f, 0.0f, (int)(91.0f * role.getLevelPercent()), 5, 91, 5);
        return this.mouseInBox(mouseX, mouseY, startX, startY, 91, 5);
    }

    protected boolean drawPrimarySpell(Screen screen, GuiGraphics graphics, ResourceLocation icon, int i, int totalIcons, int mouseX, int mouseY) {
        int iconY = ExperiencePageBase.bookEndY(screen) / 2 + 3;
        int startX = ExperiencePageBase.bookStartX(screen) + 25;
        int offsetX = 256 / totalIcons - 5;
        int x = startX + offsetX * i;
        graphics.m_280163_(icon, x, iconY, 0.0f, 0.0f, 32, 32, 32, 32);
        return this.mouseInBox(mouseX, mouseY, x, iconY, 32, 32);
    }

    protected boolean drawPassiveSpell(Screen screen, GuiGraphics graphics, ResourceLocation icon, int i, int mouseX, int mouseY) {
        int iconY = ExperiencePageBase.bookStartY(screen) + 59;
        int startX = ExperiencePageBase.bookStartX(screen) + 25;
        int offsetX = 59;
        int x = startX + 59 * i;
        graphics.m_280163_(icon, x, iconY, 0.0f, 0.0f, 32, 32, 32, 32);
        return this.mouseInBox(mouseX, mouseY, x, iconY, 32, 32);
    }

    protected void drawPoints(Screen screen, GuiGraphics graphics, Font f, int i, int size, int points) {
        int startX = ExperiencePageBase.bookStartX(screen) + 25;
        int offsetX = 256 / size - 5;
        int spellX = startX + offsetX * i;
        int spellBubbleY = ExperiencePageBase.bookEndY(screen) / 2 + 3;
        String text = String.valueOf(points);
        int textW = f.m_92895_(text);
        int textYOffset = 5;
        int n = spellX + 16 - textW / 2;
        Objects.requireNonNull(f);
        graphics.m_280056_(f, text, n, spellBubbleY - 9 - 5, 0x404040, false);
    }

    protected boolean mouseInBox(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
    }
}

