/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.screens.masterybook;

import com.dee12452.gahoodrpg.client.screens.masterybook.ExperiencePageBase;
import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.role.IGahRole;
import com.dee12452.gahoodrpg.common.capabilities.spell.IGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerChangeRole;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerClearSpellPoints;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerIncrementSpellPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;

public class GahRolePage
extends ExperiencePageBase {
    private final UUID roleId;
    private Button[] spellPlusButtons;
    private Button clearSpellPointsButton;
    private Button activateClassButton;

    public GahRolePage(Player player, Supplier<Font> font, Consumer<Button> buttonAdder, Consumer<Button> buttonRemover, UUID roleId) {
        super(player, font, buttonAdder, buttonRemover);
        this.roleId = roleId;
    }

    @Override
    public void init(Screen screen) {
        Optional<IGahRole> role = Capabilities.commonPlayer(this.player).getRole(this.roleId);
        List<UUID> spellIds = role.orElseThrow().getPrimarySpellIds();
        this.spellPlusButtons = new Button[spellIds.size()];
        for (int idx = 0; idx < spellIds.size(); ++idx) {
            Button newButton;
            UUID spellId = spellIds.get(idx);
            this.spellPlusButtons[idx] = newButton = this.createPlusButton(screen, idx, spellIds.size(), btn -> {
                if (((IGahRole)role.get()).getAvailablePoints(this.player) > 0) {
                    ServerIncrementSpellPoint.Message msg = new ServerIncrementSpellPoint.Message(spellId);
                    NetworkChannel.sendToServer(msg);
                }
            });
            this.buttonAdder.accept(newButton);
        }
        this.clearSpellPointsButton = this.createClearSpellPointsButton(screen);
        this.buttonAdder.accept(this.clearSpellPointsButton);
        this.activateClassButton = this.createActivateButton(screen);
        this.buttonAdder.accept(this.activateClassButton);
    }

    @Override
    public void onShow(Screen screen) {
        boolean classEnabled = Capabilities.commonPlayer(this.player).isRole(this.roleId);
        Arrays.stream(this.spellPlusButtons).forEach(btn -> {
            btn.f_93624_ = classEnabled;
        });
        this.clearSpellPointsButton.f_93624_ = classEnabled;
        this.activateClassButton.f_93624_ = !classEnabled;
    }

    @Override
    public void onHide(Screen screen) {
        Arrays.stream(this.spellPlusButtons).forEach(btn -> {
            btn.f_93624_ = false;
        });
        this.clearSpellPointsButton.f_93624_ = false;
        this.activateClassButton.f_93624_ = false;
    }

    @Override
    public void render(Screen screen, GuiGraphics graphics, int mouseX, int mouseY) {
        IGahRole role = Capabilities.commonPlayer(this.player).getRole(this.roleId).orElseThrow();
        Font f = (Font)this.font.get();
        MutableComponent levelComponent = Component.m_237110_((String)"gui.gahoodrpg.masterybook.tab.spells.level", (Object[])new Object[]{role.getLevel()});
        GahRolePage.writeText(screen, graphics, f, (Component)levelComponent, 0);
        int currentLine = 0;
        GahRolePage.writeTextCenter(screen, graphics, f, role.getName(), currentLine++);
        GahRolePage.writeText(screen, graphics, f, role.getWeaponDescription(), ++currentLine);
        int spellPointsToSpend = role.getAvailablePoints(this.player);
        MutableComponent spellPointsToSpendComponent = Component.m_237110_((String)"gui.gahoodrpg.masterybook.tab.spells.spend", (Object[])new Object[]{spellPointsToSpend});
        GahRolePage.writeText(screen, graphics, f, (Component)spellPointsToSpendComponent, currentLine += 6);
        Optional<Runnable> tooltipRenderer = Optional.empty();
        List<IGahSpell> passiveSpells = role.getPassiveSpells(this.player);
        for (int i = 0; i < passiveSpells.size(); ++i) {
            IGahSpell nextSpell = passiveSpells.get(i);
            if (!this.drawPassiveSpell(screen, graphics, nextSpell.getIcon(), i, mouseX, mouseY)) continue;
            tooltipRenderer = Optional.of(() -> this.runRenderSpellTooltip(screen, graphics, nextSpell, mouseX, mouseY));
        }
        List<ILevelingGahSpell> spells = role.getPrimarySpells(this.player);
        for (int i = 0; i < spells.size(); ++i) {
            ILevelingGahSpell nextSpell = spells.get(i);
            this.drawPoints(screen, graphics, f, i, spells.size(), nextSpell.getSpellPoints());
            if (!this.drawPrimarySpell(screen, graphics, nextSpell.getIcon(), i, spells.size(), mouseX, mouseY)) continue;
            tooltipRenderer = Optional.of(() -> this.runRenderSpellTooltip(screen, graphics, nextSpell, mouseX, mouseY));
        }
        if (this.drawExperienceBar(screen, graphics, role, mouseX, mouseY)) {
            tooltipRenderer = Optional.of(() -> this.runRenderExperienceTooltip(graphics, f, role, mouseX, mouseY));
        }
        tooltipRenderer.ifPresent(Runnable::run);
    }

    private void runRenderSpellTooltip(Screen screen, GuiGraphics graphics, IGahSpell spell, int mouseX, int mouseY) {
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(spell.getName());
        components.add(Component.m_237119_());
        components.addAll(spell.getDescriptions());
        components.add(Component.m_237119_());
        GahStats spellStats = spell.getStats(this.player);
        if (spellStats.strength() > 0.0f) {
            components.add(GahRolePage.gahAttributeLabel("spell.gahoodrpg.damage.power", spellStats.strength()));
        }
        if (spellStats.intelligence() > 0.0f) {
            components.add(GahRolePage.gahAttributeLabel("spell.gahoodrpg.damage.magic", spellStats.intelligence()));
        }
        if (spellStats.toughness() > 0.0f) {
            components.add(GahRolePage.gahAttributeLabel("spell.gahoodrpg.resist.power", spellStats.toughness()));
        }
        if (spellStats.aegis() > 0.0f) {
            components.add(GahRolePage.gahAttributeLabel("spell.gahoodrpg.resist.magic", spellStats.toughness()));
        }
        graphics.m_280245_(screen.getMinecraft().f_91062_, components.stream().map(Component::m_7532_).toList(), mouseX, mouseY);
    }

    private Button createClearSpellPointsButton(Screen screen) {
        int buttonWidth = 50;
        int buttonTextHeight = 20;
        int buttonHeight = 40;
        return Button.m_253074_((Component)Component.m_237115_((String)"gui.gahoodrpg.masterybook.tab.spells.reset"), btn -> NetworkChannel.sendToServer(new ServerClearSpellPoints.Message(this.roleId))).m_252794_(GahRolePage.bookStartX(screen) + 15, GahRolePage.bookEndY(screen) - 40 - 20).m_253046_(50, 20).m_253136_();
    }

    private Button createActivateButton(Screen screen) {
        int buttonWidth = 50;
        int buttonTextHeight = 20;
        int buttonXOffset = 15;
        int buttonYOffset = 15;
        return Button.m_253074_((Component)Component.m_237115_((String)"gui.gahoodrpg.masterybook.tab.spells.activate"), btn -> {
            CommonPlayerCapability cap = Capabilities.commonPlayer(this.player);
            Optional<IGahRole> currentRole = cap.getCurrentRole();
            currentRole.ifPresent(role -> role.getAllSpells(this.player).forEach(spell -> spell.onDisable(this.player)));
            NetworkChannel.sendToServer(new ServerChangeRole.Message(this.roleId));
            cap.getRole(this.roleId).ifPresent(role -> role.getAllSpells(this.player).forEach(spell -> spell.onEnable(this.player)));
            btn.f_93624_ = false;
            this.clearSpellPointsButton.f_93624_ = true;
            Arrays.stream(this.spellPlusButtons).forEach(buttonToShow -> {
                buttonToShow.f_93624_ = true;
            });
        }).m_252794_(GahRolePage.bookEndX(screen) - 50 - 15, GahRolePage.bookStartY(screen) + 15).m_253046_(50, 20).m_253136_();
    }

    private static Component gahAttributeLabel(String label, float amount) {
        Style statsStyle = Style.f_131099_.m_131150_(Style.f_131100_).m_131140_(ChatFormatting.LIGHT_PURPLE);
        return Component.m_237110_((String)label, (Object[])new Object[]{(int)Math.ceil(amount)}).m_130948_(statsStyle);
    }
}

