/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.screens.masterybook;

import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public abstract class MasteryBookPage {
    public static final int BOOK_SIDE = 256;
    protected static final int SKILL_SIDE = 32;
    protected static final ResourceLocation EXPERIENCE_BAR_EMPTY_RESOURCE_LOCATION = new ResourceLocationBuilder("experience_bar_empty").gui();
    protected static final ResourceLocation EXPERIENCE_BAR_FILLED_RESOURCE_LOCATION = new ResourceLocationBuilder("experience_bar_filled").gui();
    protected final Player player;
    protected final Supplier<Font> font;
    protected final Consumer<Button> buttonAdder;
    protected final Consumer<Button> buttonRemover;

    public MasteryBookPage(Player player, Supplier<Font> font, Consumer<Button> buttonAdder, Consumer<Button> buttonRemover) {
        this.player = player;
        this.font = font;
        this.buttonAdder = buttonAdder;
        this.buttonRemover = buttonRemover;
    }

    public abstract void init(Screen var1);

    public abstract void onShow(Screen var1);

    public abstract void onHide(Screen var1);

    public abstract void render(Screen var1, GuiGraphics var2, int var3, int var4);

    public static int bookStartX(Screen screen) {
        return (screen.f_96543_ - 256) / 2;
    }

    public static int bookEndX(Screen screen) {
        return MasteryBookPage.bookStartX(screen) + 256;
    }

    public static int bookStartY(Screen screen) {
        return 0;
    }

    public static int bookEndY(Screen screen) {
        return 256;
    }

    public static int bookMiddleX(Screen screen) {
        return (MasteryBookPage.bookStartX(screen) + MasteryBookPage.bookEndX(screen)) / 2;
    }

    public static int bookMiddleY(Screen screen) {
        return (MasteryBookPage.bookStartY(screen) + MasteryBookPage.bookEndY(screen)) / 2;
    }

    public static void writeText(Screen screen, GuiGraphics graphics, Font f, String text, int lineNumber) {
        int bookTextMarginY = 25;
        int bookTextMarginX = 20;
        MutableComponent mutableComponent = Component.m_237115_((String)text);
        int n = MasteryBookPage.bookStartX(screen) + 20;
        int n2 = MasteryBookPage.bookStartY(screen) + 25;
        Objects.requireNonNull(f);
        graphics.m_280614_(f, (Component)mutableComponent, n, n2 + 9 * lineNumber, 0x404040, false);
    }

    public static void writeText(Screen screen, GuiGraphics graphics, Font f, Component text, int lineNumber) {
        int bookTextMarginY = 25;
        int bookTextMarginX = 20;
        int n = MasteryBookPage.bookStartX(screen) + 20;
        int n2 = MasteryBookPage.bookStartY(screen) + 25;
        Objects.requireNonNull(f);
        graphics.m_280614_(f, text, n, n2 + 9 * lineNumber, 0x404040, false);
    }

    public static void writeTextCenter(Screen screen, GuiGraphics graphics, Font f, String text, int lineNumber) {
        int bookTextMarginY = 25;
        MutableComponent component = Component.m_237115_((String)text);
        int n = MasteryBookPage.bookMiddleX(screen) - f.m_92852_((FormattedText)component) / 2;
        int n2 = MasteryBookPage.bookStartY(screen) + 25;
        Objects.requireNonNull(f);
        graphics.m_280614_(f, (Component)component, n, n2 + 9 * lineNumber, 0x404040, false);
    }

    public static void writeTextCenter(Screen screen, GuiGraphics graphics, Font f, Component text, int lineNumber) {
        int bookTextMarginY = 25;
        int n = MasteryBookPage.bookMiddleX(screen) - f.m_92852_((FormattedText)text) / 2;
        int n2 = MasteryBookPage.bookStartY(screen) + 25;
        Objects.requireNonNull(f);
        graphics.m_280614_(f, text, n, n2 + 9 * lineNumber, 0x404040, false);
    }
}

