/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.screens.masterybook;

import com.dee12452.gahoodrpg.client.screens.masterybook.GahRolePage;
import com.dee12452.gahoodrpg.client.screens.masterybook.MasteryBookPage;
import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.ClientPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.role.GahRoles;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MasteryBookScreen
extends Screen {
    private static final ResourceLocation BOOK_TEXTURE_RESOURCE_LOCATION = new ResourceLocationBuilder("mastery_book_texture").gui();
    private final ClientPlayerCapability capability;
    private MasteryBookPage[] currentPages;
    private int currentPageIdx;
    private final MasteryBookPage[] rolePages;

    public MasteryBookScreen(Player player) {
        super(GameNarrator.f_93310_);
        Supplier<Font> fontSupplier = () -> this.f_96547_;
        List<UUID> roles = GahRoles.getRoles().stream().map(Pair::getLeft).toList();
        this.rolePages = new MasteryBookPage[roles.size()];
        for (int idx = 0; idx < roles.size(); ++idx) {
            this.rolePages[idx] = new GahRolePage(player, fontSupplier, x$0 -> {
                Button cfr_ignored_0 = (Button)this.m_142416_((GuiEventListener)x$0);
            }, x$0 -> this.m_169411_((GuiEventListener)x$0), roles.get(idx));
        }
        this.capability = Capabilities.clientPlayer(player);
        this.currentPages = this.rolePages;
        this.currentPageIdx = this.capability.getMasteryBookTabPage();
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"x"), btn -> Optional.ofNullable(this.f_96541_).ifPresent(mc -> mc.m_91152_(null))).m_252794_(this.f_96543_ / 2 + 128 + 10, 10).m_253046_(20, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), btn -> this.updatePage(Math.max(0, this.currentPageIdx - 1))).m_252794_(this.f_96543_ / 2 - 128 - 25, 103).m_253046_(20, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), btn -> this.updatePage(Math.min(this.currentPages.length - 1, this.currentPageIdx + 1))).m_252794_(this.f_96543_ / 2 + 128 + 5, 103).m_253046_(20, 20).m_253136_());
        this.addTabs();
        ArrayList<MasteryBookPage> allPages = new ArrayList<MasteryBookPage>();
        allPages.addAll(Lists.newArrayList((Object[])this.rolePages));
        allPages.forEach(page -> {
            page.init(this);
            page.onHide(this);
        });
        this.currentPages[this.currentPageIdx].onShow(this);
    }

    private void updatePage(int nextPage) {
        if (nextPage == this.currentPageIdx) {
            return;
        }
        this.currentPages[this.currentPageIdx].onHide(this);
        this.currentPageIdx = nextPage;
        this.currentPages[this.currentPageIdx].onShow(this);
        this.capability.setMasteryBookTabPage(this.currentPageIdx);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float p_96565_) {
        this.m_280273_(graphics);
        this.renderBook(graphics);
        for (Renderable renderable : this.f_169369_) {
            renderable.m_88315_(graphics, mouseX, mouseY, p_96565_);
        }
        this.currentPages[this.currentPageIdx].render(this, graphics, mouseX, mouseY);
    }

    private void renderBook(@NotNull GuiGraphics graphics) {
        int sidePixels = 256;
        int i = (this.f_96543_ - 256) / 2;
        graphics.m_280218_(BOOK_TEXTURE_RESOURCE_LOCATION, i, 2, 0, 0, 256, 256);
    }

    private void addTabs() {
        ArrayList<Button> tabButtons = new ArrayList<Button>();
        int idx = 0;
        tabButtons.add(this.newTab("gui.gahoodrpg.masterybook.tab.roles", idx++, btn -> this.changeSection(this.rolePages, 0)));
        tabButtons.forEach(x$0 -> {
            Button cfr_ignored_0 = (Button)this.m_142416_((GuiEventListener)x$0);
        });
    }

    private Button newTab(String tabText, int idx, Button.OnPress onPress) {
        int buffer = 5;
        int w = 50;
        int h = 20;
        return Button.m_253074_((Component)Component.m_237115_((String)tabText), (Button.OnPress)onPress).m_252794_(MasteryBookPage.bookStartX(this) - 50 - 5, MasteryBookPage.bookStartY(this) + 5 + 20 * idx).m_253046_(50, 20).m_253136_();
    }

    private void changeSection(MasteryBookPage[] newPages, int tabId) {
        this.currentPages[this.currentPageIdx].onHide(this);
        this.currentPages = newPages;
        this.currentPageIdx = 0;
        this.currentPages[this.currentPageIdx].onShow(this);
        this.capability.setMasteryBookTab(tabId);
        this.capability.setMasteryBookTabPage(this.currentPageIdx);
    }
}

