/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.widgets;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.role.IGahRole;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.items.curios.belt.CooldownBeltItem;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;

public class CooldownsOverlayWidget
implements Renderable {
    private static final ResourceLocation BELT_COOLDOWN_OVERLAY = new ResourceLocationBuilder("spells/overlays/belt").gui();
    private static final int SRC_SIDE = 16;

    public void m_88315_(@NotNull GuiGraphics graphics, int i1, int i2, float f) {
        Entity cameraEntity = Minecraft.m_91087_().m_91288_();
        if (!(cameraEntity instanceof Player)) {
            return;
        }
        Player player = (Player)cameraEntity;
        CommonPlayerCapability cap = Capabilities.commonPlayer(player);
        Optional<IGahRole> role = cap.getCurrentRole();
        if (role.isEmpty()) {
            return;
        }
        int xOffset = 0;
        CooldownsOverlayWidget.renderPassiveCooldowns(graphics, player, xOffset++, role.get());
        CooldownsOverlayWidget.renderBeltCooldown(graphics, player, xOffset++);
        List<SpellGuiInfo> spellGuiInfos = CooldownsOverlayWidget.getSpellGuiInfos(player, role.get());
        for (int idx = 0; idx < spellGuiInfos.size() && role.get().isUsingRoleEquipment(player); ++idx) {
            CooldownsOverlayWidget.renderSpell(graphics, player, idx, spellGuiInfos.get(idx));
        }
    }

    private static List<SpellGuiInfo> getSpellGuiInfos(Player player, IGahRole role) {
        ArrayList<SpellGuiInfo> spellGuiInfos = new ArrayList<SpellGuiInfo>();
        List<ILevelingGahSpell> roleSpells = role.getPrimarySpells(player);
        for (ILevelingGahSpell spell : roleSpells) {
            Cooldown cooldown;
            if (!spell.canUse()) continue;
            if (spell instanceof ICooldownGahSpell) {
                ICooldownGahSpell cooldownSpell = (ICooldownGahSpell)((Object)spell);
                cooldown = cooldownSpell.getCooldown();
            } else {
                cooldown = new Cooldown();
            }
            Cooldown cooldown2 = cooldown;
            SpellGuiInfo info = new SpellGuiInfo(spell.getOverlay(), cooldown2);
            spellGuiInfos.add(info);
        }
        return spellGuiInfos;
    }

    private static void renderSpell(GuiGraphics graphics, Player player, int x, SpellGuiInfo info) {
        CooldownsOverlayWidget.renderSpellAt(graphics, player, info.overlay, Optional.ofNullable(info.cooldown).orElse(new Cooldown()), x, 0);
    }

    private static void renderPassiveCooldowns(GuiGraphics graphics, Player player, int xOffset, IGahRole role) {
        List<IGahSpell> passiveSpells = role.getPassiveSpells(player);
        for (int idx = 0; idx < passiveSpells.size(); ++idx) {
            Cooldown cooldown;
            IGahSpell passiveSpell = passiveSpells.get(idx);
            if (passiveSpell instanceof ICooldownGahSpell) {
                ICooldownGahSpell cooldownSpell = (ICooldownGahSpell)passiveSpell;
                v0 = cooldownSpell.getCooldown();
            } else {
                v0 = cooldown = new Cooldown();
            }
            if (cooldown.check((LivingEntity)player)) continue;
            CooldownsOverlayWidget.renderSpellAt(graphics, player, passiveSpell.getOverlay(), cooldown, xOffset + idx, 1);
        }
    }

    private static void renderBeltCooldown(GuiGraphics graphics, Player player, int xOffset) {
        Optional<Cooldown> cooldown = CooldownsOverlayWidget.findBeltCooldown(player);
        if (cooldown.isEmpty() || cooldown.get().check((LivingEntity)player)) {
            return;
        }
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        graphics.m_280163_(BELT_COOLDOWN_OVERLAY, xOffset * 16 + 8 * (xOffset + 1), screenHeight - 48, 16.0f, 0.0f, 16, 16, 32, 16);
        float percent = cooldown.get().getCooldownPercent((LivingEntity)player);
        graphics.m_280163_(BELT_COOLDOWN_OVERLAY, xOffset * 16 + 8 * (xOffset + 1), screenHeight - 48, 0.0f, 0.0f, (int)(16.0f * percent), 16, 32, 16);
    }

    private static void renderSpellAt(GuiGraphics graphics, Player player, ResourceLocation texture, Cooldown cooldown, int xOffset, int yOffset) {
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        graphics.m_280163_(texture, xOffset * 16 + 8 * (xOffset + 1), screenHeight - 24 * (yOffset + 1), 16.0f, 0.0f, 16, 16, 32, 16);
        float percent = cooldown.getCooldownPercent((LivingEntity)player);
        graphics.m_280163_(texture, xOffset * 16 + 8 * (xOffset + 1), screenHeight - 24 * (yOffset + 1), 0.0f, 0.0f, (int)(16.0f * percent), 16, 32, 16);
    }

    private static Optional<Cooldown> findBeltCooldown(Player player) {
        Item item;
        Optional<SlotResult> beltCurio = EntityUtils.getCuriosSlot((LivingEntity)player, SlotTypePreset.BELT.getIdentifier());
        Optional<ItemStack> beltItemStack = beltCurio.map(SlotResult::stack).filter(stack -> !stack.m_41619_());
        if (beltItemStack.isPresent() && (item = beltItemStack.get().m_41720_()) instanceof CooldownBeltItem) {
            CooldownBeltItem beltTrinket = (CooldownBeltItem)item;
            return beltTrinket.getCooldown(beltItemStack.get());
        }
        return Optional.empty();
    }

    private record SpellGuiInfo(ResourceLocation overlay, @Nullable Cooldown cooldown) {
    }
}

