/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.widgets;

import com.dee12452.gahoodrpg.client.GahoodRPGClient;
import com.dee12452.gahoodrpg.client.GahoodRPGConfig;
import com.dee12452.gahoodrpg.client.widgets.GahWidgetBase;
import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.ClientPlayerCapability;
import com.dee12452.gahoodrpg.common.combat.dps.PlayerDps;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class DpsMeterWidget
extends GahWidgetBase {
    private static final ResourceLocation TEXTURE = new ResourceLocationBuilder("dps_meter_ribbon").gui();

    public void m_88315_(@NotNull GuiGraphics graphics, int i1, int i2, float f) {
        Optional<GahoodRPGConfig> config = Optional.ofNullable(GahoodRPGClient.getInstance().getClientPlayer()).map(Capabilities::clientPlayer).map(ClientPlayerCapability::getConfig);
        if (!config.map(GahoodRPGConfig::isDpsMeterEnabled).orElse(false).booleanValue()) {
            return;
        }
        List<Pair<String, PlayerDps>> dpsList = GahoodRPGClient.getInstance().getAllPlayerDps();
        int idx = 0;
        Optional<Pair<String, PlayerDps>> clientPlayerDps = GahoodRPGClient.getInstance().getClientPlayerDps();
        if (clientPlayerDps.isPresent()) {
            this.drawPlayerDps(graphics, (String)clientPlayerDps.get().getKey(), (PlayerDps)clientPlayerDps.get().getValue(), idx++);
        }
        for (Pair<String, PlayerDps> dps : dpsList) {
            if (clientPlayerDps.isPresent() && clientPlayerDps.get().getValue() == dps.getValue()) continue;
            this.drawPlayerDps(graphics, (String)dps.getKey(), (PlayerDps)dps.getValue(), idx++);
            if (idx < 3) continue;
            break;
        }
    }

    private void drawPlayerDps(GuiGraphics graphics, String playerName, PlayerDps dps, int idx) {
        playerName = playerName.length() > 14 ? String.format("%s...", playerName.substring(0, 12)) : playerName;
        this.drawSprite(graphics, TEXTURE, 0, 0, 56, 18, 4, 4 + 20 * idx, 56, 18);
        this.drawScaleText(graphics, playerName, 8, 8 + 20 * idx, 0.6f);
        this.drawScaleText(graphics, String.format("DPS: %.2f", Float.valueOf(dps.dpsMeter().calculate())), 15, 15 + 20 * idx, 0.85f);
    }
}

