/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.widgets;

import com.dee12452.gahoodrpg.client.GahoodRPGClient;
import com.dee12452.gahoodrpg.common.entities.projectile.FrostBlast;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class FrostBlastBarWidget
implements Renderable {
    public static final FrostBlastBarWidget INSTANCE = new FrostBlastBarWidget();
    private static final ResourceLocation PROGRESS_EMPTY = new ResourceLocationBuilder("spells/mage_frost_beam_progress").gui();
    private static final ResourceLocation PROGRESS_FILLED = new ResourceLocationBuilder("spells/mage_frost_beam_progress_filled").gui();
    private int ticks = 0;

    private FrostBlastBarWidget() {
    }

    public void tick() {
        int playerTicks = Optional.ofNullable(GahoodRPGClient.getInstance().getClientPlayer()).map(p -> p.f_19797_).orElse(0);
        if (!this.isFrostBlastProgressBarEnabled()) {
            this.ticks = playerTicks;
            return;
        }
        if (playerTicks - this.ticks >= FrostBlast.TICK_DURATION) {
            GahoodRPGClient.getInstance().setProgressBarType(GahoodRPGClient.ProgressBarType.NONE);
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int p_253973_, int p_254325_, float p_254004_) {
        if (!this.isFrostBlastProgressBarEnabled()) {
            return;
        }
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        this.drawProgressBg(graphics, screenWidth, screenHeight);
        this.drawProgress(graphics, screenWidth, screenHeight);
    }

    private void drawProgressBg(GuiGraphics graphics, int w, int h) {
        graphics.m_280163_(PROGRESS_EMPTY, 4, h - 32 - 5, 0.0f, 0.0f, 100, 10, 100, 10);
    }

    private void drawProgress(GuiGraphics graphics, int w, int h) {
        int progressWidth = 100 * this.getElapsedTicks() / FrostBlast.TICK_DURATION;
        graphics.m_280163_(PROGRESS_FILLED, 4, h - 32 - 5, 0.0f, 0.0f, progressWidth, 10, 100, 10);
    }

    private boolean isFrostBlastProgressBarEnabled() {
        return GahoodRPGClient.getInstance().getProgressBarType() == GahoodRPGClient.ProgressBarType.FROST_BLAST;
    }

    private int getElapsedTicks() {
        return Optional.ofNullable(GahoodRPGClient.getInstance().getClientPlayer()).map(p -> p.f_19797_).orElse(0) - this.ticks;
    }
}

