/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.client.widgets;

import com.dee12452.gahoodrpg.client.GahoodRPGClient;
import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SelectedSwapsWidget
implements Renderable {
    private static final int SWAP_IMAGE_SIDE = 16;
    private static final ResourceLocation MAIN_HAND_SWAP_SELECT = new ResourceLocationBuilder("main_hand_select_border").gui();
    private static final ResourceLocation OFF_HAND_SWAP_SELECT = new ResourceLocationBuilder("off_hand_select_border").gui();
    private final InventoryScreen screen;
    private final Player player;

    public SelectedSwapsWidget(InventoryScreen screen) {
        this.screen = screen;
        this.player = GahoodRPGClient.getInstance().getClientPlayer();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int i1, int i2, float f) {
        CommonPlayerCapability capability = Capabilities.commonPlayer(this.player);
        Optional<Item> mainHandItem = this.toItem(capability.getMainHandSwapItemId());
        Optional<Item> offHandItem = this.toItem(capability.getOffHandSwapItemId());
        for (Slot slot : ((InventoryMenu)this.screen.m_6262_()).f_38839_) {
            if (!slot.m_6657_()) continue;
            if (mainHandItem.map(arg_0 -> ((ItemStack)slot.m_7993_()).m_150930_(arg_0)).orElse(false).booleanValue()) {
                this.drawSelect(graphics, slot, MAIN_HAND_SWAP_SELECT);
            }
            if (!offHandItem.map(arg_0 -> ((ItemStack)slot.m_7993_()).m_150930_(arg_0)).orElse(false).booleanValue()) continue;
            this.drawSelect(graphics, slot, OFF_HAND_SWAP_SELECT);
        }
    }

    private void drawSelect(GuiGraphics graphics, Slot slot, ResourceLocation swapSelectResource) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.m_280163_(swapSelectResource, this.screen.getGuiLeft() + slot.f_40220_, this.screen.getGuiTop() + slot.f_40221_, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.disableBlend();
    }

    private Optional<Item> toItem(int itemId) {
        if (itemId < 0) {
            return Optional.empty();
        }
        return Optional.of(Item.m_41445_((int)itemId));
    }
}

