/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.blocks;

import com.dee12452.gahoodrpg.utils.ColorUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class BlockParticleEmitter {
    private final ParticleOptions options;
    private final Level level;
    private final BlockPos pos;

    public BlockParticleEmitter(ParticleOptions options, Level level, BlockPos pos) {
        this.options = options;
        this.level = level;
        this.pos = pos;
    }

    public static ParticleOptions dust(String hexColor) {
        Vector3f colorVec = ColorUtils.hexToVec3f(hexColor);
        return new DustParticleOptions(colorVec, 1.0f);
    }

    public void addParticles(RandomSource randomSource) {
        this.addParticles(randomSource, false);
    }

    public void addParticles(RandomSource randomSource, boolean particlesAllowedInWalls) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = this.pos.m_121945_(direction);
            if (this.level.m_8055_(blockpos).m_60804_((BlockGetter)this.level, blockpos) && !particlesAllowedInWalls) {
                return;
            }
            Direction.Axis direction$axis = direction.m_122434_();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)randomSource.m_188501_();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)randomSource.m_188501_();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)randomSource.m_188501_();
            this.level.m_7106_(this.options, (double)this.pos.m_123341_() + d1, (double)this.pos.m_123342_() + d2, (double)this.pos.m_123343_() + d3, 0.0, 0.0, 0.0);
        }
    }
}

