/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.blocks;

import com.dee12452.gahoodrpg.common.blocks.BlockParticleEmitter;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class GahLevelBlock
extends Block {
    private final ParticleOptions options;
    private final boolean lightOnAttack;
    private final boolean lightOnStep;
    private final int level;
    private final int experience;
    private final MiningTool miningTool;

    public GahLevelBlock(MapColor material, float strength, MiningTool miningTool) {
        this(ParticleProperties.NONE, GahBlockProperties.NONE, miningTool, material, strength);
    }

    public GahLevelBlock(ParticleProperties particleProperties, GahBlockProperties gahBlockProperties, MiningTool miningTool, MapColor material, float strength, boolean isNoOcclusion) {
        super(GahLevelBlock.createBlockBehavior(material, strength, isNoOcclusion));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.FALSE));
        this.options = particleProperties.options;
        this.lightOnAttack = particleProperties.lightOnAttack;
        this.lightOnStep = particleProperties.lightOnStep;
        this.level = gahBlockProperties.level;
        this.experience = gahBlockProperties.experience;
        this.miningTool = miningTool;
    }

    public GahLevelBlock(ParticleProperties particleProperties, GahBlockProperties gahBlockProperties, MiningTool miningTool, MapColor material, float strength) {
        this(particleProperties, gahBlockProperties, miningTool, material, strength, false);
    }

    public GahLevelBlock(GahBlockProperties gahBlockProperties, MiningTool miningTool, MapColor material, float strength) {
        this(ParticleProperties.NONE, gahBlockProperties, miningTool, material, strength);
    }

    public void m_6256_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player) {
        super.m_6256_(state, level, pos, player);
        if (this.lightOnAttack) {
            this.interact(level, pos, state, player.m_217043_());
        }
    }

    public void m_141947_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Entity entity) {
        super.m_141947_(level, pos, state, entity);
        if (this.lightOnStep && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.interact(level, pos, state, livingEntity.m_217043_());
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_);
    }

    public void m_213898_(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            return;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.FALSE), 3);
    }

    public void m_214162_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource source) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            return;
        }
        this.spawnParticles(level, pos, source);
    }

    public MiningTool getMiningTool() {
        return this.miningTool;
    }

    public int getLevel() {
        return this.level;
    }

    public int getExperience() {
        return this.experience;
    }

    protected void spawnParticles(Level level, BlockPos pos, RandomSource randomSource) {
        new BlockParticleEmitter(this.options, level, pos).addParticles(randomSource);
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61443_});
    }

    private void interact(Level level, BlockPos pos, BlockState state, RandomSource randomSource) {
        new BlockParticleEmitter(this.options, level, pos).addParticles(randomSource);
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            return;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 3);
    }

    private static BlockBehaviour.Properties createBlockBehavior(MapColor mapColor, float strength, boolean isNoOcclusion) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_60977_().m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 9 : 0);
        if (isNoOcclusion) {
            properties = properties.m_60955_();
        }
        properties = strength < 0.0f ? properties.m_60913_(-1.0f, 3600000.0f) : properties.m_60978_(strength);
        return properties;
    }

    public record ParticleProperties(ParticleOptions options, boolean lightOnAttack, boolean lightOnStep) {
        public static final ParticleProperties NONE = new ParticleProperties(BlockParticleEmitter.dust("#FFFFFF"), false, false);
    }

    public record GahBlockProperties(int level, int experience) {
        public static final GahBlockProperties NONE = new GahBlockProperties(1, 1);

        public static GahBlockProperties fromLevel(int level) {
            return new GahBlockProperties(level, level * 5);
        }
    }

    public static enum MiningTool {
        PICKAXE(item -> item instanceof PickaxeItem),
        AXE(item -> item instanceof AxeItem),
        SHOVEL(item -> item instanceof ShovelItem);

        private final Predicate<Item> minePredicate;

        private MiningTool(Predicate<Item> minePredicate) {
            this.minePredicate = minePredicate;
        }

        public boolean canMine(Item item) {
            return this.minePredicate.test(item);
        }
    }
}

