/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.blocks;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.ServerPlayerCapability;
import com.dee12452.gahoodrpg.common.data.GraveboxData;
import com.dee12452.gahoodrpg.common.entities.block.GahBlockEntityTicker;
import com.dee12452.gahoodrpg.common.entities.block.GraveboxBlockEntity;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraveboxBlock
extends Block
implements EntityBlock {
    public GraveboxBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(3.0f).m_222994_().m_60922_((var1, var2, var3, var4) -> false));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new GraveboxBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level p_153212_, @NotNull BlockState p_153213_, @NotNull BlockEntityType<T> p_153214_) {
        return GahBlockEntityTicker::ticker;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof GraveboxBlockEntity)) {
            return InteractionResult.PASS;
        }
        GraveboxBlockEntity gravebox = (GraveboxBlockEntity)blockEntity;
        if (!gravebox.isOwner(player)) {
            EntityUtils.playSound((LivingEntity)player, SoundEvents.f_11798_);
            player.m_5661_((Component)Component.m_237115_((String)"message.gahoodrpg.gravebox.incorrect_owner"), true);
            return InteractionResult.PASS;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerPlayerCapability caps = Capabilities.serverPlayer(serverPlayer);
        GraveboxData.PopResult popResult = caps.getGraveboxData().popCache(player);
        if (popResult == GraveboxData.PopResult.EMPTY) {
            EntityUtils.playSound((LivingEntity)player, SoundEvents.f_11797_);
            player.m_5661_((Component)Component.m_237115_((String)"message.gahoodrpg.gravebox.empty"), false);
        } else if (popResult == GraveboxData.PopResult.FULL_INVENTORY) {
            EntityUtils.playSound((LivingEntity)player, SoundEvents.f_11797_);
            player.m_5661_((Component)Component.m_237115_((String)"message.gahoodrpg.gravebox.full_inventory"), false);
        } else {
            EntityUtils.playSound((LivingEntity)player, SoundEvents.f_11796_);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState p_49849_, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GraveboxBlockEntity) {
            GraveboxBlockEntity gravebox = (GraveboxBlockEntity)blockEntity;
            gravebox.setOwner(player);
        }
    }
}

