/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities;

import com.dee12452.gahoodrpg.common.capabilities.CapabilityHolder;
import com.dee12452.gahoodrpg.common.capabilities.ClientPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.ICapability;
import com.dee12452.gahoodrpg.common.capabilities.ServerPlayerCapability;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import org.jetbrains.annotations.Nullable;

public class Capabilities {
    private static final Capability<CommonPlayerCapability> COMMON_PLAYER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CommonPlayerCapability>(){});
    private static final Capability<ClientPlayerCapability> CLIENT_PLAYER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ClientPlayerCapability>(){});
    private static final Capability<ServerPlayerCapability> SERVER_PLAYER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ServerPlayerCapability>(){});

    private Capabilities() {
    }

    public static CommonPlayerCapability commonPlayer(@Nullable Player player) {
        return Capabilities.getPlayerCapability(player, COMMON_PLAYER_CAPABILITY, new CommonPlayerCapability());
    }

    public static ClientPlayerCapability clientPlayer(Player player) {
        return Capabilities.getPlayerCapability(player, CLIENT_PLAYER_CAPABILITY, new ClientPlayerCapability());
    }

    public static ServerPlayerCapability serverPlayer(ServerPlayer player) {
        return Capabilities.getPlayerCapability((Player)player, SERVER_PLAYER_CAPABILITY, new ServerPlayerCapability());
    }

    public static List<CapabilityHolder<?>> getServerPlayerCapabilities() {
        return Lists.newArrayList((Object[])new CapabilityHolder[]{new CapabilityHolder<CommonPlayerCapability>(COMMON_PLAYER_CAPABILITY, CommonPlayerCapability::new), new CapabilityHolder<ServerPlayerCapability>(SERVER_PLAYER_CAPABILITY, ServerPlayerCapability::new)});
    }

    public static List<CapabilityHolder<?>> getClientPlayerCapabilities() {
        return Lists.newArrayList((Object[])new CapabilityHolder[]{new CapabilityHolder<CommonPlayerCapability>(COMMON_PLAYER_CAPABILITY, CommonPlayerCapability::new), new CapabilityHolder<ClientPlayerCapability>(CLIENT_PLAYER_CAPABILITY, ClientPlayerCapability::new)});
    }

    public static CapabilityHolder<?> getClientPlayerCapability() {
        return new CapabilityHolder<ClientPlayerCapability>(CLIENT_PLAYER_CAPABILITY, ClientPlayerCapability::new);
    }

    public static void restorePlayerCapabilities(Player original, Player newlyCreated, List<CapabilityHolder<?>> capabilityHolders) {
        original.reviveCaps();
        capabilityHolders.forEach(c -> Capabilities.restoreCapability(original, newlyCreated, c.getDirectCapability()));
        original.invalidateCaps();
    }

    private static <T extends ICapability> void restoreCapability(Player original, Player current, Capability<T> capability) {
        current.getCapability(capability).ifPresent(currCap -> original.getCapability(capability).ifPresent(ogCap -> currCap.deserializeNBT((Tag)((CompoundTag)ogCap.serializeNBT()))));
    }

    private static <T extends ICapability> T getPlayerCapability(@Nullable Player player, Capability<T> capability, T defaultCapability) {
        return (T)Optional.ofNullable(player).map(p -> (ICapability)p.getCapability(capability).orElse((Object)defaultCapability)).orElse(defaultCapability);
    }
}

