/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities;

import com.dee12452.gahoodrpg.common.capabilities.ICapability;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityHolder<T extends ICapability>
implements ICapabilitySerializable<CompoundTag> {
    private final Capability<T> capability;
    private final Supplier<T> objectCreator;
    @Nullable
    private T object;

    public CapabilityHolder(Capability<T> capability, Supplier<T> objectCreator) {
        this.capability = capability;
        this.objectCreator = objectCreator;
    }

    @NotNull
    public <J> LazyOptional<J> getCapability(@NotNull Capability<J> cap, @Nullable Direction side) {
        return this.capability.orEmpty(cap, LazyOptional.of(this::getCapabilityObject));
    }

    public Capability<T> getDirectCapability() {
        return this.capability;
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)this.getCapabilityObject().serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.getCapabilityObject().deserializeNBT((Tag)nbt);
    }

    @NotNull
    public T getCapabilityObject() {
        if (Optional.ofNullable(this.object).isEmpty()) {
            this.object = (ICapability)this.objectCreator.get();
        }
        return this.object;
    }

    @NotNull
    public T getPlayerCapability(Player player) {
        return (T)((ICapability)player.getCapability(this.getDirectCapability()).orElse(this.getCapabilityObject()));
    }
}

