/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities;

import com.dee12452.gahoodrpg.common.capabilities.ICapability;
import com.dee12452.gahoodrpg.common.capabilities.role.GahRoles;
import com.dee12452.gahoodrpg.common.capabilities.role.IGahRole;
import com.dee12452.gahoodrpg.common.capabilities.spell.GahSpells;
import com.dee12452.gahoodrpg.common.capabilities.spell.IGahSpell;
import com.dee12452.gahoodrpg.utils.NbtUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class CommonPlayerCapability
implements ICapability {
    private final Map<UUID, IGahRole> roles = new HashMap<UUID, IGahRole>();
    private final Map<UUID, IGahSpell> spells = new HashMap<UUID, IGahSpell>();
    @Nullable
    private UUID roleId;
    private int mainHandSwapItemId = -1;
    private int offHandSwapItemId = -1;

    public boolean isRole(UUID roleId) {
        return Optional.ofNullable(this.roleId).map(id -> id.equals(roleId)).orElse(false);
    }

    public Optional<UUID> getCurrentRoleId() {
        return Optional.ofNullable(this.roleId);
    }

    public Optional<IGahRole> getCurrentRole() {
        return this.getRole(this.roleId);
    }

    public Optional<IGahRole> getRole(@Nullable UUID roleId) {
        if (roleId == null) {
            return Optional.empty();
        }
        if (!this.roles.containsKey(roleId)) {
            this.roles.put(roleId, GahRoles.createRole(roleId));
        }
        return Optional.of(this.roles.get(roleId));
    }

    public void setRole(@Nullable UUID roleId) {
        this.roleId = roleId;
    }

    public IGahSpell getSpell(UUID spellId) {
        if (!this.spells.containsKey(spellId)) {
            this.spells.put(spellId, GahSpells.createSpell(spellId));
        }
        return this.spells.get(spellId);
    }

    public void resetRole(UUID roleId) {
        if (!this.roles.containsKey(roleId)) {
            return;
        }
        IGahRole role = this.roles.get(roleId);
        this.roles.remove(roleId);
        List<UUID> spellIds = role.getAllSpellIds();
        spellIds.forEach(this.spells::remove);
    }

    public void clear() {
        this.roles.clear();
        this.spells.clear();
        this.mainHandSwapItemId = -1;
        this.offHandSwapItemId = -1;
    }

    public int getMainHandSwapItemId() {
        return this.mainHandSwapItemId;
    }

    public void setMainHandSwapItemId(int mainHandSwapItemId) {
        this.mainHandSwapItemId = mainHandSwapItemId;
    }

    public int getOffHandSwapItemId() {
        return this.offHandSwapItemId;
    }

    public void setOffHandSwapItemId(int offHandSwapItemId) {
        this.offHandSwapItemId = offHandSwapItemId;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        NbtUtils.putMap(nbt, "roles", this.roles);
        NbtUtils.putMap(nbt, "spells", this.spells);
        Optional.ofNullable(this.roleId).ifPresent(id -> nbt.m_128362_("roleId", id));
        nbt.m_128405_("mainHandSwapItemId", this.mainHandSwapItemId);
        nbt.m_128405_("offHandSwapItemId", this.offHandSwapItemId);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        NbtUtils.extractMap(nbt, "roles", this.roles, id -> this.getRole((UUID)id).orElseThrow());
        NbtUtils.extractMap(nbt, "spells", this.spells, this::getSpell);
        if (nbt.m_128441_("roleId")) {
            this.roleId = nbt.m_128342_("roleId");
        }
        this.mainHandSwapItemId = nbt.m_128451_("mainHandSwapItemId");
        this.offHandSwapItemId = nbt.m_128451_("offHandSwapItemId");
    }
}

