/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.role;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.role.IGahRole;
import com.dee12452.gahoodrpg.common.capabilities.spell.IGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public abstract class GahRole
implements IGahRole {
    private int experience = 0;

    @Override
    public int getLevel() {
        return Math.min(this.getMaxLevel(), this.getLevel(this.experience));
    }

    @Override
    public void addExperience(int exp) {
        this.experience += exp;
    }

    @Override
    public void setExperience(int exp) {
        this.experience = exp;
    }

    @Override
    public int getExperience() {
        return this.experience;
    }

    @Override
    public int calculateExperienceTo(int level) {
        return (int)Math.pow((double)level / this.getXPModifier(), 2.0) + 1;
    }

    @Override
    public float getLevelPercent() {
        int currentLevel = this.getLevel();
        if (currentLevel == this.getMaxLevel()) {
            return 0.0f;
        }
        int currentLevelXP = this.calculateExperienceTo(currentLevel);
        int nextLevelXP = this.calculateExperienceTo(currentLevel + 1);
        return Math.min(1.0f, (float)(this.experience - currentLevelXP) / (float)(nextLevelXP - currentLevelXP));
    }

    @Override
    public int getAvailablePoints(Player player) {
        return this.getLevel() - this.getUsedPoints(player);
    }

    @Override
    public void reset(Player player) {
        this.experience = 0;
        this.getPrimarySpells(player).forEach(spell -> spell.setSpellPoints(0));
    }

    @Override
    public Component getName() {
        return null;
    }

    @Override
    public Component getWeaponDescription() {
        return null;
    }

    @Override
    public boolean isUsingRoleEquipment(Player player) {
        return false;
    }

    @Override
    public List<UUID> getPrimarySpellIds() {
        return null;
    }

    @Override
    public List<UUID> getPassiveSpellIds() {
        return null;
    }

    @Override
    public int getUsedPoints(Player player) {
        return this.getPrimarySpells(player).stream().mapToInt(ILevelingGahSpell::getSpellPoints).sum();
    }

    @Override
    public boolean hasSpell(UUID spellId) {
        return Stream.concat(this.getPrimarySpellIds().stream(), this.getPassiveSpellIds().stream()).anyMatch(spellId::equals);
    }

    @Override
    public List<IGahSpell> getAllSpells(Player player) {
        CommonPlayerCapability cap = Capabilities.commonPlayer(player);
        return Stream.concat(this.getPrimarySpellIds().stream(), this.getPassiveSpellIds().stream()).map(cap::getSpell).toList();
    }

    @Override
    public List<ILevelingGahSpell> getPrimarySpells(Player player) {
        CommonPlayerCapability cap = Capabilities.commonPlayer(player);
        return this.getPrimarySpellIds().stream().map(cap::getSpell).map(spell -> (ILevelingGahSpell)spell).toList();
    }

    @Override
    public List<IGahSpell> getPassiveSpells(Player player) {
        CommonPlayerCapability cap = Capabilities.commonPlayer(player);
        return this.getPassiveSpellIds().stream().map(cap::getSpell).toList();
    }

    private int getLevel(int experience) {
        return (int)Math.floor(Math.sqrt(experience) * this.getXPModifier());
    }
}

