/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.role;

import com.dee12452.gahoodrpg.common.capabilities.role.GuardianRole;
import com.dee12452.gahoodrpg.common.capabilities.role.IGahRole;
import com.dee12452.gahoodrpg.common.capabilities.role.MageRole;
import com.dee12452.gahoodrpg.common.capabilities.role.RangerRole;
import com.dee12452.gahoodrpg.common.capabilities.role.RoleNotRegisteredException;
import com.dee12452.gahoodrpg.common.capabilities.role.WarriorRole;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;

public class GahRoles {
    private static final Map<UUID, Supplier<IGahRole>> REGISTER = new HashMap<UUID, Supplier<IGahRole>>();

    private GahRoles() {
    }

    public static void register(UUID id, Supplier<IGahRole> roleSupplier) {
        REGISTER.put(id, roleSupplier);
    }

    public static void deregister(UUID id) {
        REGISTER.remove(id);
    }

    public static List<Pair<UUID, Supplier<IGahRole>>> getRoles() {
        return REGISTER.entrySet().stream().map(Pair::of).toList();
    }

    public static IGahRole createRole(UUID roleId) throws IllegalArgumentException {
        if (!REGISTER.containsKey(roleId)) {
            throw new RoleNotRegisteredException(String.format("No role registered with UUID %s", roleId.toString()));
        }
        return REGISTER.get(roleId).get();
    }

    static {
        GahRoles.register(WarriorRole.ID, WarriorRole::new);
        GahRoles.register(GuardianRole.ID, GuardianRole::new);
        GahRoles.register(RangerRole.ID, RangerRole::new);
        GahRoles.register(MageRole.ID, MageRole::new);
    }
}

