/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.role;

import com.dee12452.gahoodrpg.common.capabilities.spell.IGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;

public interface IGahRole
extends INBTSerializable<CompoundTag> {
    public static final double DEFAULT_XP_LEVEL_DIVIDER_MOD = 0.15;
    public static final int DEFAULT_MAX_LEVEL = 25;

    default public double getXPModifier() {
        return 0.15;
    }

    default public int getMaxLevel() {
        return 25;
    }

    public int getLevel();

    default public void setLevel(int level) {
        int levelToSet = Math.min(this.getMaxLevel(), level);
        this.setExperience(this.calculateExperienceTo(levelToSet));
    }

    public void addExperience(int var1);

    public void setExperience(int var1);

    public int getExperience();

    public int calculateExperienceTo(int var1);

    public float getLevelPercent();

    public int getAvailablePoints(Player var1);

    public int getUsedPoints(Player var1);

    public void reset(Player var1);

    public Component getName();

    public Component getWeaponDescription();

    public boolean isUsingRoleEquipment(Player var1);

    public boolean hasSpell(UUID var1);

    default public List<UUID> getAllSpellIds() {
        return Stream.concat(this.getPrimarySpellIds().stream(), this.getPassiveSpellIds().stream()).toList();
    }

    public List<UUID> getPrimarySpellIds();

    public List<UUID> getPassiveSpellIds();

    public List<IGahSpell> getAllSpells(Player var1);

    public List<ILevelingGahSpell> getPrimarySpells(Player var1);

    public List<IGahSpell> getPassiveSpells(Player var1);

    default public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("experience", this.getExperience());
        return nbt;
    }

    default public void deserializeNBT(CompoundTag nbt) {
        this.setExperience(nbt.m_128451_("experience"));
    }
}

