/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.ServerPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahCombat;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahDamageSource;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientMagicExplosion;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BladeCrashSpell
implements ILevelingGahSpell,
ICooldownGahSpell {
    public static final UUID ID = UUID.fromString("4ebacd80-59e8-4c47-b5a3-d949a123ac03");
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;
    private boolean active = false;
    private boolean clientLaunched = false;
    private int ticksActive = 0;
    private boolean forceCrash = false;

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(10.0f) - TimeUtils.secondsToTicks(0.25f) * this.getSpellPoints();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.blade_crash.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.blade_crash.description")});
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("blade_crash").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("blade_crash").overlay();
    }

    @Override
    public GahStats getStats(Player player) {
        return GahStats.spell(player, 3 + this.getSpellPoints(), 1.0f + 0.25f * (float)this.getSpellPoints(), 0.0f, 0.0f);
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        nbt.m_128379_("active", this.active);
        nbt.m_128379_("clientLaunched", this.clientLaunched);
        nbt.m_128405_("ticksActive", this.ticksActive);
        nbt.m_128379_("forceCrash", this.forceCrash);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
        this.active = nbt.m_128471_("active");
        this.clientLaunched = nbt.m_128471_("clientLaunched");
        this.ticksActive = nbt.m_128451_("ticksActive");
        this.forceCrash = nbt.m_128471_("forceCrash");
    }

    @Override
    public void onActivateSpell(Player player) {
        if (EntityUtils.isClientSide((Entity)player) || this.active) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerPlayerCapability serverCaps = Capabilities.serverPlayer(serverPlayer);
        if (player.m_7500_() || serverCaps.isSpellBlocked()) {
            return;
        }
        if (!this.getCooldown().checkAndReset((LivingEntity)player)) {
            return;
        }
        serverCaps.setSpellBlocked(true);
        this.active = true;
        this.ticksActive = 0;
        this.clientLaunched = false;
        this.forceCrash = false;
        this.syncToClient((ServerPlayer)player, ID);
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.WARRIOR_BLADE_CRASH_LAUNCH.get());
    }

    @Override
    public void onPlayerDeath(Player player, @Nullable Entity killer) {
        this.active = false;
    }

    @Override
    public void onTick(Player player) {
        if (!EntityUtils.isClientSide((Entity)player)) {
            if (!this.forceCrash) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.onBladeCrash(serverPlayer);
            return;
        }
        if (!this.active) {
            return;
        }
        if (this.shouldForce(player) || player.m_20096_() && this.ticksActive > TimeUtils.secondsToTicks(1.0f)) {
            this.forceCrash = true;
            ++this.ticksActive;
            this.syncToServer(ID);
            return;
        }
        if (this.ticksActive > 0) {
            Vec3 prevDelta = player.m_20184_();
            player.m_20334_(prevDelta.f_82479_, prevDelta.f_82480_ - (double)0.1f, prevDelta.f_82481_);
            ++this.ticksActive;
            return;
        }
        if (player.m_20096_() && !this.clientLaunched) {
            Vec3 prevDelta = player.m_20184_();
            player.m_20334_(prevDelta.f_82479_ * 1.25, 2.5, prevDelta.f_82481_ * 1.25);
            this.clientLaunched = true;
        }
        ++this.ticksActive;
    }

    @Override
    public boolean onPlayerFall(Player player, float distance) {
        if (!this.active) {
            return ILevelingGahSpell.super.onPlayerFall(player, distance);
        }
        if (EntityUtils.isClientSide((Entity)player)) {
            return true;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        this.onBladeCrash(serverPlayer);
        return true;
    }

    private void onBladeCrash(ServerPlayer player) {
        player.m_183634_();
        ServerLevel level = EntityUtils.getServerLevel((LivingEntity)player).orElseThrow();
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.WARRIOR_BLADE_CRASH_SLAM.get());
        NetworkChannel.sendToClientsInLevel(level, ClientMagicExplosion.Message.from((Entity)player));
        List entitiesToHurt = level.m_6443_(LivingEntity.class, player.m_20191_().m_82377_(4.0, 2.0, 4.0), mob -> {
            TamableAnimal animal;
            return !(mob instanceof TamableAnimal) || !EntityUtils.is((Entity)player, (Entity)(animal = (TamableAnimal)mob).m_269323_());
        });
        for (LivingEntity target : entitiesToHurt) {
            GahStats spellStats = this.getStats((Player)player);
            GahCombat combat = new GahCombat(spellStats);
            GahDamage damage = combat.calculateDamage((Entity)target);
            target.m_6469_(GahDamageSource.direct((Entity)player, (Entity)player, damage), damage.total());
            Vec3 vec3 = EntityUtils.getAngleTo((LivingEntity)player, (Entity)target).m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(1.175);
            if (!(vec3.m_82556_() > 0.0)) continue;
            target.m_5997_(vec3.f_82479_, 0.25, vec3.f_82481_);
        }
        ServerPlayerCapability serverCaps = Capabilities.serverPlayer(player);
        serverCaps.setSpellBlocked(false);
        this.active = false;
        this.forceCrash = false;
        this.ticksActive = 0;
        this.syncToClient(player, ID);
    }

    private boolean shouldForce(Player player) {
        return player.isInFluidType() || player.f_146808_ || player.m_203117_() || player.m_146890_();
    }
}

