/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IProjectileGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.projectile.WarriorSword;
import com.dee12452.gahoodrpg.common.items.weapons.GahSwordItem;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BladeDanceSpell
implements ILevelingGahSpell,
ICooldownGahSpell,
IProjectileGahSpell<WarriorSword> {
    public static final UUID ID = UUID.fromString("f8fb4bc4-3d09-42b9-9772-db82157a21fb");
    private static final double DASH_SPEED = 1.12;
    private static final int DASH_TICK_DURATION = TimeUtils.secondsToTicks(0.2f);
    private static final int RADIUS = 2;
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;
    private boolean dashing = false;
    private int dashTicks = 0;
    private Vec3 dashDirection = Vec3.f_82478_;
    private final Set<UUID> hitEntities = new HashSet<UUID>();
    private final Set<UUID> swordEntities = new HashSet<UUID>();

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(8.0f) - TimeUtils.secondsToTicks(0.15f) * this.getSpellPoints();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.blade_dance.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return this.loadDescriptions("spell.gahoodrpg.blade_dance.description", 2);
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("blade_dance").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("blade_dance").overlay();
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        nbt.m_128405_("chargeTicks", this.dashTicks);
        nbt.m_128379_("charging", this.dashing);
        nbt.m_128347_("chargeDirectionX", this.dashDirection.f_82479_);
        nbt.m_128347_("chargeDirectionY", this.dashDirection.f_82480_);
        nbt.m_128347_("chargeDirectionZ", this.dashDirection.f_82481_);
        nbt.m_128405_("hitEntitiesSize", this.hitEntities.size());
        int idx = 0;
        for (UUID id : this.hitEntities) {
            nbt.m_128362_(String.format("hitEntity%d", idx), id);
            ++idx;
        }
        nbt.m_128405_("swordEntitiesSize", this.swordEntities.size());
        idx = 0;
        for (UUID id : this.swordEntities) {
            nbt.m_128362_(String.format("swordEntity%d", idx), id);
            ++idx;
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
        this.dashTicks = nbt.m_128451_("chargeTicks");
        this.dashing = nbt.m_128471_("charging");
        double chargeDirectionX = nbt.m_128459_("chargeDirectionX");
        double chargeDirectionY = nbt.m_128459_("chargeDirectionY");
        double chargeDirectionZ = nbt.m_128459_("chargeDirectionZ");
        this.dashDirection = new Vec3(chargeDirectionX, chargeDirectionY, chargeDirectionZ);
        this.hitEntities.clear();
        int hitEntitiesSize = nbt.m_128451_("hitEntitiesSize");
        for (int idx = 0; idx < hitEntitiesSize; ++idx) {
            this.hitEntities.add(nbt.m_128342_(String.format("hitEntity%d", idx)));
        }
        this.swordEntities.clear();
        int swordEntitiesSize = nbt.m_128451_("swordEntitiesSize");
        for (int idx = 0; idx < swordEntitiesSize; ++idx) {
            this.swordEntities.add(nbt.m_128342_(String.format("swordEntity%d", idx)));
        }
    }

    @Override
    @NotNull
    public EntityType<WarriorSword> getEntityType() {
        return (EntityType)ProjectileEntityRegistry.WARRIOR_SWORD.get();
    }

    @Override
    public float getProjectilePowerDamage(Player player) {
        return 0.5f + 0.5f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectilePowerCoefficient(Player player) {
        return 1.0f + 0.05f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectileMagicDamage(Player player) {
        return 1.0f + 0.5f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectileMagicCoefficient(Player player) {
        return 1.0f + 0.05f * (float)this.getSpellPoints();
    }

    @Override
    public boolean canShoot(ServerPlayer player) {
        return !Capabilities.serverPlayer(player).isSpellBlocked() && this.getCooldown().check((LivingEntity)player) && !this.dashing;
    }

    @Override
    public boolean shoot(ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.m_9236_();
        for (Vec3 pos : this.findSwordLocations(player)) {
            WarriorSword sword = this.createSword(player, pos);
            if (!level.m_7967_((Entity)sword)) {
                this.swordEntities.stream().map(arg_0 -> ((ServerLevel)level).m_8791_(arg_0)).filter(Objects::nonNull).forEach(Entity::m_146870_);
                this.swordEntities.clear();
                return false;
            }
            this.swordEntities.add(sword.m_20148_());
        }
        this.dashTicks = 0;
        this.dashDirection = player.m_20154_();
        this.dashing = true;
        return true;
    }

    @Override
    public void onTick(Player player) {
        if (!this.dashing) {
            return;
        }
        if (this.dashTicks > DASH_TICK_DURATION) {
            this.onStopDash(player);
            return;
        }
        if (EntityUtils.isClientSide((Entity)player)) {
            player.m_20334_(this.dashDirection.f_82479_ * 1.12, player.m_20184_().f_82480_, this.dashDirection.f_82481_ * 1.12);
        }
        ++this.dashTicks;
    }

    @Override
    public boolean canHurt(Player player, WarriorSword projectile, LivingEntity target) {
        if (this.hitEntities.contains(target.m_20148_())) {
            return false;
        }
        return IProjectileGahSpell.super.canHurt(player, projectile, target);
    }

    @Override
    public GahDamage onHit(Player player, WarriorSword projectile, LivingEntity target) {
        this.hitEntities.add(target.m_20148_());
        return IProjectileGahSpell.super.onHit(player, projectile, target);
    }

    @Override
    public void onShootSuccess(ServerPlayer player) {
        this.getCooldown().reset((LivingEntity)player);
        EntityUtils.swing(player);
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.WARRIOR_BLADE_DANCE_DASH.get());
        this.syncToClient(player, ID);
    }

    private void onStopDash(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerLevel level = (ServerLevel)serverPlayer.m_9236_();
            this.swordEntities.stream().map(arg_0 -> ((ServerLevel)level).m_8791_(arg_0)).filter(Objects::nonNull).forEach(Entity::m_146870_);
        }
        this.dashTicks = 0;
        this.dashDirection = Vec3.f_82478_;
        this.dashing = false;
        this.hitEntities.clear();
        this.swordEntities.clear();
    }

    private WarriorSword createSword(ServerPlayer player, Vec3 pos) {
        WarriorSword sword = new WarriorSword((LivingEntity)player);
        sword.m_146884_(pos);
        Item item = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        if (item instanceof GahSwordItem) {
            GahSwordItem swordItem = (GahSwordItem)item;
            sword.setItem(swordItem);
        }
        Vec3 lookAngle = player.m_20154_();
        sword.m_20334_(lookAngle.f_82479_ * 1.12 * 1.5, player.m_20184_().f_82480_, lookAngle.f_82481_ * 1.12 * 1.5);
        sword.setProjectileXRot(-90.0f);
        double rotationYaw = Math.toDegrees(Math.atan2(sword.m_20184_().f_82479_, sword.m_20184_().f_82481_));
        sword.setProjectileYRot((float)rotationYaw);
        return sword;
    }

    private List<Vec3> findSwordLocations(ServerPlayer player) {
        Vec3 lookAngle = player.m_20154_();
        Vec3 lookAngleNoY = new Vec3(lookAngle.f_82479_, 0.0, lookAngle.f_82481_);
        Vec3 playerPosition = player.m_20318_(1.0f);
        Vec3 position = new Vec3(playerPosition.f_82479_, (playerPosition.f_82480_ + player.m_20188_()) / 2.0, playerPosition.f_82481_);
        Vec3 rightVector = new Vec3(-lookAngleNoY.f_82481_, 0.0, lookAngleNoY.f_82479_);
        ArrayList<Vec3> spots = new ArrayList<Vec3>();
        spots.add(position.m_82549_(lookAngleNoY.m_82490_(2.0)));
        spots.add(position.m_82546_(rightVector.m_82490_(2.0)));
        spots.add(position.m_82549_(rightVector.m_82490_(2.0)));
        return spots;
    }
}

