/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahCombat;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.combat.effects.GahMagicPoisonEffect;
import com.dee12452.gahoodrpg.common.combat.effects.MobEffects;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.living.RangerWolf;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class CallOfTheWildSpell
implements ICooldownGahSpell,
ILevelingGahSpell {
    public static final UUID ID = UUID.fromString("061241a3-26a8-4a84-a465-681e58f0120c");
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;
    private boolean applyNextAttack = false;

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(10.0f) - TimeUtils.secondsToTicks(0.1f) * this.getSpellPoints();
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("call_of_the_wild").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("call_of_the_wild").overlay();
    }

    @Override
    public GahStats getStats(Player player) {
        return GahStats.spell(player, 0.0f, 0.0f, 0.5f + 0.25f * (float)this.getSpellPoints(), 0.25f + 0.1f * (float)this.getSpellPoints());
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.call_of_the_wild_spell.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.call_of_the_wild_spell.description")});
    }

    @Override
    public GahDamage onIndirectAttackEntity(ServerPlayer player, Entity attackingEntity, Entity target) {
        if (!(target instanceof LivingEntity)) {
            return GahDamage.ZERO;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        if (!(attackingEntity instanceof RangerWolf) || !this.applyNextAttack) {
            return GahDamage.ZERO;
        }
        this.applyNextAttack = false;
        GahStats stats = this.getStats((Player)player);
        GahCombat combat = new GahCombat(stats);
        GahDamage damage = combat.calculateMagicDamage(target);
        int poisonDamage = Math.max(1, (int)damage.magicDamage());
        MobEffectInstance effectInstance = new MobEffectInstance((MobEffect)MobEffects.GAH_POISON.get(), GahMagicPoisonEffect.DEFAULT_TICKS_ACTIVE / 2, poisonDamage);
        livingTarget.m_7292_(effectInstance);
        return GahDamage.ZERO;
    }

    @Override
    public void onActivateSpell(Player player) {
        if (EntityUtils.isClientSide((Entity)player)) {
            return;
        }
        if (!this.getCooldown().checkAndReset((LivingEntity)player)) {
            return;
        }
        this.applyNextAttack = true;
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.RANGER_CALL_OF_THE_WILD_SPAWN.get());
        this.syncToClient((ServerPlayer)player, ID);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("applyNextAttack", this.applyNextAttack);
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        this.applyNextAttack = nbt.m_128471_("applyNextAttack");
    }
}

