/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IProjectileGahSpell;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.projectile.CrashGuardShield;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CrashGuardSpell
implements ILevelingGahSpell,
ICooldownGahSpell,
IProjectileGahSpell<CrashGuardShield> {
    public static final UUID ID = UUID.fromString("3b63ade3-00fe-4773-b7ba-12005e2fc6fe");
    private static final int TICKS_TO_LIVE = TimeUtils.secondsToTicks(5.0f);
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.crash_guard.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return this.loadDescriptions("spell.gahoodrpg.crash_guard.description", 3);
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("crash_guard").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("crash_guard").overlay();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
    }

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(12.0f);
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
    }

    @Override
    @NotNull
    public EntityType<CrashGuardShield> getEntityType() {
        return (EntityType)ProjectileEntityRegistry.CRASH_GUARD_SHIELD.get();
    }

    @Override
    public float getProjectilePowerDamage(Player player) {
        return 2.5f + (float)(2 * this.getSpellPoints());
    }

    @Override
    public float getProjectilePowerCoefficient(Player player) {
        return 1.0f + 0.25f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectileMagicDamage(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectileMagicCoefficient(Player player) {
        return 0.0f;
    }

    @Override
    public boolean canShoot(ServerPlayer player) {
        if (!this.getCooldown().check((LivingEntity)player)) {
            return false;
        }
        List<Vec3> crashSpots = this.findCrashSpots(player);
        return crashSpots.stream().allMatch(spot -> this.canPlace(player, (Vec3)spot));
    }

    @Override
    public boolean shoot(ServerPlayer player) {
        List<Vec3> crashSpots = this.findCrashSpots(player);
        ArrayList<CrashGuardShield> shields = new ArrayList<CrashGuardShield>();
        Level level = player.m_9236_();
        for (int idx = 0; idx < crashSpots.size(); ++idx) {
            CrashGuardShield shield = new CrashGuardShield((LivingEntity)player, crashSpots.get(idx), 90 * idx, TICKS_TO_LIVE + (int)Math.floor((double)this.getSpellPoints() * 0.5));
            if (!level.m_7967_((Entity)shield)) {
                shields.forEach(Entity::m_146870_);
                return false;
            }
            shields.add(shield);
        }
        return true;
    }

    @Override
    public void onShootSuccess(ServerPlayer player) {
        this.getCooldown().reset((LivingEntity)player);
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.GUARDIAN_CRASH_GUARD_SPAWN.get());
        this.syncToClient(player, ID);
    }

    private List<Vec3> findCrashSpots(ServerPlayer player) {
        double offset = 3.0;
        Vec3 lookAngle = player.m_20154_();
        Vec3 lookAngleNoY = new Vec3(lookAngle.f_82479_, 0.0, lookAngle.f_82481_);
        Vec3 playerPosition = player.m_20318_(1.0f);
        Vec3 position = new Vec3(playerPosition.f_82479_, playerPosition.f_82480_ + 3.0, playerPosition.f_82481_);
        Vec3 rightVector = new Vec3(-lookAngleNoY.f_82481_, 0.0, lookAngleNoY.f_82479_);
        ArrayList<Vec3> spots = new ArrayList<Vec3>();
        spots.add(position.m_82549_(lookAngleNoY.m_82490_(3.0)));
        spots.add(position.m_82546_(rightVector.m_82490_(3.0)));
        spots.add(position.m_82546_(lookAngleNoY.m_82490_(3.0)));
        spots.add(position.m_82549_(rightVector.m_82490_(3.0)));
        return spots;
    }

    private boolean canPlace(ServerPlayer player, Vec3 spot) {
        Vec3i spotI = new Vec3i((int)spot.f_82479_, (int)spot.f_82480_, (int)spot.f_82481_);
        return !player.m_9236_().m_8055_(new BlockPos(spotI)).m_280296_();
    }
}

